/*
 * Decompiled with CFR 0.152.
 */
package com.loop54;

import com.loop54.ILoop54Client;
import com.loop54.RequestContainer;
import com.loop54.exceptions.Loop54ArgumentException;
import com.loop54.exceptions.Loop54Exception;
import com.loop54.http.IRequestManager;
import com.loop54.model.request.AutoCompleteRequest;
import com.loop54.model.request.CreateEventsRequest;
import com.loop54.model.request.GetBasketRecommendationsRequest;
import com.loop54.model.request.GetComplementaryEntitiesRequest;
import com.loop54.model.request.GetEntitiesByAttributeRequest;
import com.loop54.model.request.GetEntitiesRequest;
import com.loop54.model.request.GetPopularEntitiesRequest;
import com.loop54.model.request.GetRecentEntitiesRequest;
import com.loop54.model.request.GetRecommendedEntitiesRequest;
import com.loop54.model.request.GetRelatedEntitiesRequest;
import com.loop54.model.request.Request;
import com.loop54.model.request.SearchRequest;
import com.loop54.model.response.AutoCompleteResponse;
import com.loop54.model.response.GetBasketRecommendationsResponse;
import com.loop54.model.response.GetComplementaryEntitiesResponse;
import com.loop54.model.response.GetEntitiesByAttributeResponse;
import com.loop54.model.response.GetEntitiesResponse;
import com.loop54.model.response.GetPopularEntitiesResponse;
import com.loop54.model.response.GetRecentEntitiesResponse;
import com.loop54.model.response.GetRecommendedEntitiesResponse;
import com.loop54.model.response.GetRelatedEntitiesResponse;
import com.loop54.model.response.Response;
import com.loop54.model.response.SearchResponse;
import com.loop54.user.IRemoteClientInfo;
import com.loop54.user.IRemoteClientInfoProvider;
import com.loop54.user.UserMetaData;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class Loop54Client
implements ILoop54Client {
    private static final String SEARCH_REQUEST_NAME = "search";
    private static final String AUTO_COMPLETE_REQUEST_NAME = "autoComplete";
    private static final String GET_ENTITIES_REQUEST_NAME = "getEntities";
    private static final String GET_ENTITIES_BY_ATTRIBUTE_REQUEST_NAME = "getEntitiesByAttribute";
    private static final String GET_RELATED_ENTITIES_REQUEST_NAME = "getRelatedEntities";
    private static final String GET_COMPLEMENTARY_ENTITIES_REQUEST_NAME = "getComplementaryEntities";
    private static final String GET_BASKET_RECOMMENDATIONS_REQUEST_NAME = "getBasketRecommendations";
    private static final String GET_RECOMMENDED_ENTITIES_REQUEST_NAME = "getRecommendedEntities";
    private static final String GET_POPULAR_ENTITIES_REQUEST_NAME = "getPopularEntities";
    private static final String GET_RECENT_ENTITIES_REQUEST_NAME = "getRecentEntities";
    private static final String CREATE_EVENTS_REQUEST_NAME = "createEvents";
    private static final String SYNC_REQUEST_NAME = "sync";
    private final IRequestManager requestManager;
    private final IRemoteClientInfoProvider remoteClientInfoProvider;

    public Loop54Client(IRequestManager requestManager, IRemoteClientInfoProvider remoteClientInfoProvider) {
        if (requestManager == null) {
            throw new IllegalArgumentException("Request manager was null");
        }
        if (remoteClientInfoProvider == null) {
            throw new IllegalArgumentException("Remote client info provider was null");
        }
        this.requestManager = requestManager;
        this.remoteClientInfoProvider = remoteClientInfoProvider;
    }

    public IRequestManager getRequestManager() {
        return this.requestManager;
    }

    @Override
    public SearchResponse search(SearchRequest request) throws Loop54Exception {
        return this.getFuture(this.searchAsync(request));
    }

    @Override
    public SearchResponse search(RequestContainer<SearchRequest> request) throws Loop54Exception {
        return this.getFuture(this.searchAsync(request));
    }

    @Override
    public CompletableFuture<SearchResponse> searchAsync(SearchRequest request) {
        return this.searchAsync(Loop54Client.getRequestContainer(request));
    }

    @Override
    public CompletableFuture<SearchResponse> searchAsync(RequestContainer<SearchRequest> request) {
        return this.callEngine(SEARCH_REQUEST_NAME, request, SearchResponse.class);
    }

    @Override
    public GetEntitiesResponse getEntities(GetEntitiesRequest request) throws Loop54Exception {
        return this.getFuture(this.getEntitiesAsync(request));
    }

    @Override
    public GetEntitiesResponse getEntities(RequestContainer<GetEntitiesRequest> request) throws Loop54Exception {
        return this.getFuture(this.getEntitiesAsync(request));
    }

    @Override
    public CompletableFuture<GetEntitiesResponse> getEntitiesAsync(GetEntitiesRequest request) {
        return this.getEntitiesAsync(Loop54Client.getRequestContainer(request));
    }

    @Override
    public CompletableFuture<GetEntitiesResponse> getEntitiesAsync(RequestContainer<GetEntitiesRequest> request) {
        return this.callEngine(GET_ENTITIES_REQUEST_NAME, request, GetEntitiesResponse.class);
    }

    @Override
    public GetEntitiesByAttributeResponse getEntitiesByAttribute(GetEntitiesByAttributeRequest request) throws Loop54Exception {
        return this.getFuture(this.getEntitiesByAttributeAsync(request));
    }

    @Override
    public GetEntitiesByAttributeResponse getEntitiesByAttribute(RequestContainer<GetEntitiesByAttributeRequest> request) throws Loop54Exception {
        return this.getFuture(this.getEntitiesByAttributeAsync(request));
    }

    @Override
    public CompletableFuture<GetEntitiesByAttributeResponse> getEntitiesByAttributeAsync(GetEntitiesByAttributeRequest request) {
        return this.getEntitiesByAttributeAsync(Loop54Client.getRequestContainer(request));
    }

    @Override
    public CompletableFuture<GetEntitiesByAttributeResponse> getEntitiesByAttributeAsync(RequestContainer<GetEntitiesByAttributeRequest> request) {
        return this.callEngine(GET_ENTITIES_BY_ATTRIBUTE_REQUEST_NAME, request, GetEntitiesByAttributeResponse.class);
    }

    @Override
    public AutoCompleteResponse autoComplete(AutoCompleteRequest request) throws Loop54Exception {
        return this.getFuture(this.autoCompleteAsync(request));
    }

    @Override
    public AutoCompleteResponse autoComplete(RequestContainer<AutoCompleteRequest> request) throws Loop54Exception {
        return this.getFuture(this.autoCompleteAsync(request));
    }

    @Override
    public CompletableFuture<AutoCompleteResponse> autoCompleteAsync(AutoCompleteRequest request) {
        return this.autoCompleteAsync(Loop54Client.getRequestContainer(request));
    }

    @Override
    public CompletableFuture<AutoCompleteResponse> autoCompleteAsync(RequestContainer<AutoCompleteRequest> request) {
        return this.callEngine(AUTO_COMPLETE_REQUEST_NAME, request, AutoCompleteResponse.class);
    }

    @Override
    public GetRelatedEntitiesResponse getRelatedEntities(GetRelatedEntitiesRequest request) throws Loop54Exception {
        return this.getFuture(this.getRelatedEntitiesAsync(request));
    }

    @Override
    public GetRelatedEntitiesResponse getRelatedEntities(RequestContainer<GetRelatedEntitiesRequest> request) throws Loop54Exception {
        return this.getFuture(this.getRelatedEntitiesAsync(request));
    }

    @Override
    public CompletableFuture<GetRelatedEntitiesResponse> getRelatedEntitiesAsync(GetRelatedEntitiesRequest request) {
        return this.getRelatedEntitiesAsync(Loop54Client.getRequestContainer(request));
    }

    @Override
    public CompletableFuture<GetRelatedEntitiesResponse> getRelatedEntitiesAsync(RequestContainer<GetRelatedEntitiesRequest> request) {
        return this.callEngine(GET_RELATED_ENTITIES_REQUEST_NAME, request, GetRelatedEntitiesResponse.class);
    }

    @Override
    public GetComplementaryEntitiesResponse getComplementaryEntities(GetComplementaryEntitiesRequest request) throws Loop54Exception {
        return this.getFuture(this.getComplementaryEntitiesAsync(request));
    }

    @Override
    public GetComplementaryEntitiesResponse getComplementaryEntities(RequestContainer<GetComplementaryEntitiesRequest> request) throws Loop54Exception {
        return this.getFuture(this.getComplementaryEntitiesAsync(request));
    }

    @Override
    public CompletableFuture<GetComplementaryEntitiesResponse> getComplementaryEntitiesAsync(GetComplementaryEntitiesRequest request) {
        return this.getComplementaryEntitiesAsync(Loop54Client.getRequestContainer(request));
    }

    @Override
    public CompletableFuture<GetComplementaryEntitiesResponse> getComplementaryEntitiesAsync(RequestContainer<GetComplementaryEntitiesRequest> request) {
        return this.callEngine(GET_COMPLEMENTARY_ENTITIES_REQUEST_NAME, request, GetComplementaryEntitiesResponse.class);
    }

    @Override
    public GetBasketRecommendationsResponse getBasketRecommendations(GetBasketRecommendationsRequest request) throws Loop54Exception {
        return this.getFuture(this.getBasketRecommendationsAsync(request));
    }

    @Override
    public GetBasketRecommendationsResponse getBasketRecommendations(RequestContainer<GetBasketRecommendationsRequest> request) throws Loop54Exception {
        return this.getFuture(this.getBasketRecommendationsAsync(request));
    }

    @Override
    public CompletableFuture<GetBasketRecommendationsResponse> getBasketRecommendationsAsync(GetBasketRecommendationsRequest request) {
        return this.getBasketRecommendationsAsync(Loop54Client.getRequestContainer(request));
    }

    @Override
    public CompletableFuture<GetBasketRecommendationsResponse> getBasketRecommendationsAsync(RequestContainer<GetBasketRecommendationsRequest> request) {
        return this.callEngine(GET_BASKET_RECOMMENDATIONS_REQUEST_NAME, request, GetBasketRecommendationsResponse.class);
    }

    @Override
    public GetRecommendedEntitiesResponse getRecommendedEntities(GetRecommendedEntitiesRequest request) throws Loop54Exception {
        return this.getFuture(this.getRecommendedEntitiesAsync(request));
    }

    @Override
    public GetRecommendedEntitiesResponse getRecommendedEntities(RequestContainer<GetRecommendedEntitiesRequest> request) throws Loop54Exception {
        return this.getFuture(this.getRecommendedEntitiesAsync(request));
    }

    @Override
    public CompletableFuture<GetRecommendedEntitiesResponse> getRecommendedEntitiesAsync(GetRecommendedEntitiesRequest request) {
        return this.getRecommendedEntitiesAsync(Loop54Client.getRequestContainer(request));
    }

    @Override
    public CompletableFuture<GetRecommendedEntitiesResponse> getRecommendedEntitiesAsync(RequestContainer<GetRecommendedEntitiesRequest> request) {
        return this.callEngine(GET_RECOMMENDED_ENTITIES_REQUEST_NAME, request, GetRecommendedEntitiesResponse.class);
    }

    @Override
    public GetPopularEntitiesResponse getPopularEntities(GetPopularEntitiesRequest request) throws Loop54Exception {
        return this.getFuture(this.getPopularEntitiesAsync(request));
    }

    @Override
    public GetPopularEntitiesResponse getPopularEntities(RequestContainer<GetPopularEntitiesRequest> request) throws Loop54Exception {
        return this.getFuture(this.getPopularEntitiesAsync(request));
    }

    @Override
    public CompletableFuture<GetPopularEntitiesResponse> getPopularEntitiesAsync(GetPopularEntitiesRequest request) {
        return this.getPopularEntitiesAsync(Loop54Client.getRequestContainer(request));
    }

    @Override
    public CompletableFuture<GetPopularEntitiesResponse> getPopularEntitiesAsync(RequestContainer<GetPopularEntitiesRequest> request) {
        return this.callEngine(GET_POPULAR_ENTITIES_REQUEST_NAME, request, GetPopularEntitiesResponse.class);
    }

    @Override
    public GetRecentEntitiesResponse getRecentEntities(GetRecentEntitiesRequest request) throws Loop54Exception {
        return this.getFuture(this.getRecentEntitiesAsync(request));
    }

    @Override
    public GetRecentEntitiesResponse getRecentEntities(RequestContainer<GetRecentEntitiesRequest> request) throws Loop54Exception {
        return this.getFuture(this.getRecentEntitiesAsync(request));
    }

    @Override
    public CompletableFuture<GetRecentEntitiesResponse> getRecentEntitiesAsync(GetRecentEntitiesRequest request) {
        return this.getRecentEntitiesAsync(Loop54Client.getRequestContainer(request));
    }

    @Override
    public CompletableFuture<GetRecentEntitiesResponse> getRecentEntitiesAsync(RequestContainer<GetRecentEntitiesRequest> request) {
        return this.callEngine(GET_RECENT_ENTITIES_REQUEST_NAME, request, GetRecentEntitiesResponse.class);
    }

    @Override
    public Response sync() throws Loop54Exception {
        return this.sync(new Request());
    }

    @Override
    public Response sync(Request request) throws Loop54Exception {
        return this.getFuture(this.syncAsync(request));
    }

    @Override
    public Response sync(RequestContainer<Request> request) throws Loop54Exception {
        return this.getFuture(this.syncAsync(request));
    }

    @Override
    public CompletableFuture<Response> syncAsync() {
        return this.syncAsync(new Request());
    }

    @Override
    public CompletableFuture<Response> syncAsync(Request request) {
        return this.syncAsync(Loop54Client.getRequestContainer(request));
    }

    @Override
    public CompletableFuture<Response> syncAsync(RequestContainer<Request> request) {
        return this.callEngine(SYNC_REQUEST_NAME, request, Response.class);
    }

    @Override
    public Response createEvents(CreateEventsRequest request) throws Loop54Exception {
        return this.getFuture(this.createEventsAsync(request));
    }

    @Override
    public Response createEvents(RequestContainer<CreateEventsRequest> request) throws Loop54Exception {
        return this.getFuture(this.createEventsAsync(request));
    }

    @Override
    public CompletableFuture<Response> createEventsAsync(CreateEventsRequest request) {
        return this.createEventsAsync(Loop54Client.getRequestContainer(request));
    }

    @Override
    public CompletableFuture<Response> createEventsAsync(RequestContainer<CreateEventsRequest> request) {
        return this.callEngine(CREATE_EVENTS_REQUEST_NAME, request, Response.class);
    }

    @Override
    public Response customCall(String name, Request request) throws Loop54Exception {
        return this.getFuture(this.customCallAsync(name, request));
    }

    @Override
    public Response customCall(String name, RequestContainer<Request> request) throws Loop54Exception {
        return this.getFuture(this.customCallAsync(name, request));
    }

    @Override
    public CompletableFuture<Response> customCallAsync(String name, Request request) {
        return this.customCallAsync(name, Loop54Client.getRequestContainer(request));
    }

    @Override
    public CompletableFuture<Response> customCallAsync(String name, RequestContainer<Request> request) {
        return this.callEngine(name, request, Response.class);
    }

    private <T extends Response> T getFuture(CompletableFuture<T> response) throws Loop54Exception {
        try {
            return (T)((Response)response.get());
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof Loop54Exception) {
                throw (Loop54Exception)ee.getCause();
            }
            throw new Loop54Exception(ee);
        }
        catch (InterruptedException ie) {
            throw new Loop54Exception(ie);
        }
    }

    private <T extends Response> CompletableFuture<T> callEngine(String requestName, RequestContainer<? extends Request> request, Class<T> responseType) {
        UserMetaData metaData = this.prepareAndValidateRequest(requestName, request);
        return this.requestManager.callEngineAsync(requestName, (Request)request.request, metaData, responseType);
    }

    public static <T extends Request> RequestContainer<T> getRequestContainer(T requestData, UserMetaData metaDataOverrides) {
        return new RequestContainer<T>(requestData, metaDataOverrides);
    }

    public static <T extends Request> RequestContainer<T> getRequestContainer(T requestData) {
        return Loop54Client.getRequestContainer(requestData, null);
    }

    private UserMetaData prepareAndValidateRequest(String requestName, RequestContainer<? extends Request> request) {
        if (requestName == null) {
            throw new IllegalArgumentException("Request name was null");
        }
        if (requestName.isEmpty() || Character.isUpperCase(requestName.charAt(0))) {
            throw new IllegalArgumentException("The request name must be non-empty and lower camel case.");
        }
        return this.getOrCreateMetaData(request);
    }

    private UserMetaData getOrCreateMetaData(RequestContainer<? extends Request> request) {
        UserMetaData metaData = request.metaDataOverrides.orElse(new UserMetaData());
        IRemoteClientInfo remoteClientInfo = this.remoteClientInfoProvider.getRemoteClientInfo();
        if (remoteClientInfo == null) {
            throw new Loop54ArgumentException("The " + IRemoteClientInfoProvider.class.getSimpleName() + " returned a null " + IRemoteClientInfo.class.getSimpleName() + ". Make sure you've implemented it correctly!");
        }
        metaData.setFromClientInfo(remoteClientInfo);
        return metaData;
    }

    @Override
    public void close() throws IOException {
        this.requestManager.close();
    }
}

