/*
 * Decompiled with CFR 0.152.
 */
package com.loop54.http;

import com.loop54.Loop54Settings;
import com.loop54.Utils;
import com.loop54.exceptions.EngineNotReachableException;
import com.loop54.exceptions.EngineStatusCodeException;
import com.loop54.exceptions.Loop54Exception;
import com.loop54.http.IRequestManager;
import com.loop54.model.request.Request;
import com.loop54.model.response.ErrorResponse;
import com.loop54.model.response.Response;
import com.loop54.serialization.Serializer;
import com.loop54.user.UserMetaData;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.util.Timeout;

public class RequestManager
implements IRequestManager {
    private final CloseableHttpClient httpClient;
    private final Loop54Settings settings;

    public Loop54Settings getSettings() {
        return this.settings;
    }

    public RequestManager(Loop54Settings settings) {
        if (settings == null) {
            throw new IllegalArgumentException("Settings was null");
        }
        this.settings = settings;
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(Timeout.ofMilliseconds((long)settings.getRequestTimeoutMs())).setConnectionRequestTimeout(Timeout.ofMilliseconds((long)settings.getRequestTimeoutMs())).build();
        this.httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();
    }

    @Override
    public <T extends Response> CompletableFuture<T> callEngineAsync(String action, Request requestData, UserMetaData metaData, Class<T> responseType) {
        if (action == null) {
            throw new IllegalArgumentException("Action was null");
        }
        if (requestData == null) {
            throw new IllegalArgumentException("Request data was null");
        }
        if (metaData == null) {
            throw new IllegalArgumentException("Metadata was null");
        }
        CompletableFuture future = new CompletableFuture();
        CompletableFuture.runAsync(() -> {
            try {
                RequestData request = new RequestData(action, Serializer.serialize(requestData), metaData, this.settings.getApiKey());
                future.complete(this.makeHttpRequest(request, responseType));
            }
            catch (Loop54Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T extends Response> T makeHttpRequest(RequestData request, Class<T> responseType) throws Loop54Exception {
        String content;
        CloseableHttpResponse response;
        String endpoint = this.getValidatedEndpoint();
        HttpPost httpPost = new HttpPost(endpoint + "/" + request.action);
        this.setHeadersOnRequest(httpPost, request);
        httpPost.setEntity((HttpEntity)new StringEntity(request.body, StandardCharsets.UTF_8));
        try {
            response = this.httpClient.execute((ClassicHttpRequest)httpPost);
        }
        catch (IOException ioe) {
            throw new EngineNotReachableException("Could not make request to engine at '" + endpoint + "', you might have entered the wrong endpoint or there might be a firewall blocking outgoing port 80", ioe);
        }
        HttpEntity entity = response.getEntity();
        try {
            content = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new EngineNotReachableException("Failed to receive a response from the engine at '" + endpoint + "'", e);
        }
        if (response.getCode() / 100 != 2) throw new EngineStatusCodeException(Serializer.deserialize((String)content, ErrorResponse.class).error);
        Response response2 = (Response)Serializer.deserialize(content, responseType);
        return (T)response2;
        finally {
            try {
                response.close();
            }
            catch (IOException iOException) {}
        }
    }

    private String getValidatedEndpoint() {
        String endpoint = Utils.fixEngineUrl(this.settings.getEndpoint());
        if (this.settings.getRequireHttps() && !Utils.urlIsHttps(endpoint)) {
            throw new IllegalArgumentException("If 'requireHttps' is true the endpoint needs to use the protocol 'https'");
        }
        return endpoint;
    }

    private void setHeadersOnRequest(HttpPost httpPost, RequestData request) {
        httpPost.setHeader("Content-Type", (Object)"application/json");
        httpPost.addHeader("Api-Version", (Object)"V3");
        httpPost.addHeader("Lib-Version", (Object)"Java:5.0.1");
        this.addHeaderIfNotNull(httpPost, "loop54-key", this.settings.getApiKey());
        this.addHeaderIfNotNull(httpPost, "user-id", request.userMetaData.userId);
        this.addHeaderIfNotNull(httpPost, "user-ip", request.userMetaData.ipAddress);
        this.addHeaderIfNotNull(httpPost, "user-useragent", request.userMetaData.userAgent);
        this.addHeaderIfNotNull(httpPost, "user-referer", request.userMetaData.referer);
    }

    private void addHeaderIfNotNull(HttpPost httpPost, String headerName, String headerValue) {
        if (headerValue != null) {
            httpPost.addHeader(headerName, (Object)headerValue);
        }
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    private static class RequestData {
        final String action;
        final String body;
        final UserMetaData userMetaData;
        final String apiKey;

        RequestData(String action, String body, UserMetaData userMetaData, String apiKey) {
            this.action = action;
            this.body = body;
            this.userMetaData = userMetaData;
            this.apiKey = apiKey;
        }
    }
}

