/*
 * Decompiled with CFR 0.152.
 */
package com.loop54.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.loop54.model.EntityAttributeType;
import com.loop54.model.ModelUtils;
import java.util.List;
import java.util.stream.Collectors;

public class EntityAttribute {
    private String name;
    private EntityAttributeType type;
    private List<Object> values;

    @JsonCreator
    public EntityAttribute(@JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="type") EntityAttributeType type, @JsonProperty(required=true, value="values") List<Object> values) {
        this.name = name;
        this.type = type;
        this.values = values;
    }

    public String getName() {
        return this.name;
    }

    public EntityAttributeType getType() {
        return this.type;
    }

    public <T> T getValue(Class<T> clazz) {
        return this.values.isEmpty() ? null : (T)ModelUtils.numberSafeCast(this.values.get(0), clazz);
    }

    public <T> List<T> getValues(Class<T> clazz) {
        return this.values.stream().map(value -> ModelUtils.numberSafeCast(value, clazz)).collect(Collectors.toList());
    }
}

