/*
 * Decompiled with CFR 0.152.
 */
package com.loop54.model.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.loop54.exceptions.Loop54Exception;
import com.loop54.exceptions.SerializationException;
import com.loop54.serialization.Serializer;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Response {
    public Map<String, Object> customData;

    public <T> T getCustomDataOrThrow(String key, Class<T> clazz) throws Loop54Exception {
        CustomDataContainer<T> result = this.tryGetCustomData(key, clazz);
        if (!result.foundData) {
            throw new Loop54Exception("No data with key '" + key + "' found on the response");
        }
        return result.data;
    }

    public <T> T getCustomDataOrDefault(String key, Class<T> clazz) throws Loop54Exception {
        return this.tryGetCustomData((String)key, clazz).data;
    }

    private <T> CustomDataContainer<T> tryGetCustomData(String key, Class<T> clazz) throws Loop54Exception {
        if (this.customData == null) {
            return new CustomDataContainer<Object>(false, null);
        }
        Object data = this.customData.get(key);
        if (data != null) {
            if (data instanceof LinkedHashMap) {
                try {
                    return new CustomDataContainer<T>(true, Serializer.deserialize((LinkedHashMap)data, clazz));
                }
                catch (SerializationException e) {
                    new Loop54Exception("The data with key '" + key + "' couldn't be deserialized to '" + clazz.toString() + "'", e);
                }
            }
            if (clazz.isAssignableFrom(data.getClass())) {
                return new CustomDataContainer<Object>(true, data);
            }
            throw new Loop54Exception("The data with key '" + key + "' couldn't be deserialized or cast to '" + clazz.toString() + "'");
        }
        return new CustomDataContainer<Object>(false, null);
    }

    private class CustomDataContainer<T> {
        public T data;
        public boolean foundData;

        public CustomDataContainer(boolean foundData, T data) {
            this.data = data;
            this.foundData = foundData;
        }
    }
}

