/*
 * Decompiled with CFR 0.152.
 */
package com.loop54.serialization;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.loop54.exceptions.Loop54Exception;
import com.loop54.exceptions.SerializationException;
import com.loop54.model.response.Facet;
import com.loop54.serialization.FacetJsonDeserializer;
import java.io.IOException;
import java.util.LinkedHashMap;

public class Serializer {
    public static final ObjectMapper MAPPER = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).registerModule((Module)new SimpleModule().addDeserializer(Facet.class, (JsonDeserializer)new FacetJsonDeserializer())).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public static String serialize(Object data) throws Loop54Exception {
        try {
            return MAPPER.writeValueAsString(data);
        }
        catch (JsonProcessingException jpe) {
            throw new SerializationException("Could not deserialize object of type " + data.getClass().getName(), (Exception)((Object)jpe));
        }
    }

    public static <T> T deserialize(String data, Class<T> clazz) throws Loop54Exception {
        try {
            return (T)MAPPER.readValue(data, clazz);
        }
        catch (IOException ioe) {
            throw new SerializationException("Could not deserialize object of type " + clazz.getName(), ioe);
        }
    }

    public static <T> T deserialize(LinkedHashMap data, Class<T> clazz) throws Loop54Exception {
        try {
            return (T)MAPPER.convertValue((Object)data, clazz);
        }
        catch (Exception e) {
            throw new SerializationException("Could not deserialize object of type " + clazz.getName(), e);
        }
    }
}

