/*
 * Decompiled with CFR 0.152.
 */
package com.loop54;

import com.loop54.ILoop54Client;
import com.loop54.ILoop54ClientProvider;
import com.loop54.Loop54Client;
import com.loop54.Loop54Settings;
import com.loop54.Loop54SettingsCollection;
import com.loop54.exceptions.Loop54RuntimeException;
import com.loop54.http.RequestManager;
import com.loop54.user.IRemoteClientInfoProvider;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Loop54ClientProvider
implements ILoop54ClientProvider {
    private final ConcurrentMap<String, ILoop54Client> clients = new ConcurrentHashMap<String, ILoop54Client>();

    public Loop54ClientProvider(IRemoteClientInfoProvider remoteClientInfoProvider, Loop54SettingsCollection settingsCollection) {
        if (remoteClientInfoProvider == null) {
            throw new IllegalArgumentException("remoteClientInfoProvider is null");
        }
        if (settingsCollection == null) {
            throw new IllegalArgumentException("settingsCollection is null");
        }
        if (settingsCollection.size() == 0) {
            throw new IllegalArgumentException("The provided settingsCollection cannot be empty.");
        }
        this.createClientsForSettings(settingsCollection, remoteClientInfoProvider);
    }

    private void createClientsForSettings(Loop54SettingsCollection settingsCollection, IRemoteClientInfoProvider remoteClientInfoProvider) {
        for (Map.Entry<String, Loop54Settings> setting : settingsCollection) {
            this.clients.put(setting.getKey(), new Loop54Client(new RequestManager(setting.getValue()), remoteClientInfoProvider));
        }
    }

    @Override
    public ILoop54Client getNamed(String instanceName) {
        if (instanceName == null) {
            throw new IllegalArgumentException("instanceName is null");
        }
        ILoop54Client client = this.clients.getOrDefault(instanceName, null);
        if (client == null) {
            throw new Loop54RuntimeException("Loop54 client with instance name '" + instanceName + "' is not initialized. You must add it to the settings used when initializing.");
        }
        return client;
    }

    public ILoop54Client getSingleOrThrow() {
        if (this.clients.size() != 1) {
            throw new Loop54RuntimeException("Cannot guess a single default client if there are " + this.clients.size() + " registered. Use the 'ILoop54ClientProvider.GetNamed' method instead.");
        }
        return (ILoop54Client)this.clients.values().stream().findFirst().get();
    }

    @Override
    public void close() throws IOException {
        IOException firstException = null;
        for (ILoop54Client client : this.clients.values()) {
            try {
                client.close();
            }
            catch (IOException e) {
                if (firstException == null) {
                    firstException = e;
                    continue;
                }
                firstException.addSuppressed(e);
            }
        }
        this.clients.clear();
        if (firstException != null) {
            throw firstException;
        }
    }
}

