/*
 * Decompiled with CFR 0.152.
 */
package com.loop54.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.loop54.model.response.DistinctFacet;
import com.loop54.model.response.Facet;
import com.loop54.model.response.RangeFacet;
import com.loop54.serialization.Serializer;
import java.io.IOException;

public class FacetJsonDeserializer
extends JsonDeserializer<Facet> {
    @Override
    public Facet deserialize(JsonParser parser, DeserializationContext deserializer) throws IOException {
        ObjectCodec codec = parser.getCodec();
        JsonNode node = (JsonNode)codec.readTree(parser);
        String type = node.get("type").asText();
        if ("distinct".equals(type)) {
            return this.deserializeDistinct(node);
        }
        if ("range".equals(type)) {
            return this.deserializeRange(node);
        }
        throw new IllegalArgumentException("FacetType '" + type + "' cannot be deserialized");
    }

    private DistinctFacet deserializeDistinct(JsonNode node) {
        return Serializer.MAPPER.convertValue((Object)node, DistinctFacet.class);
    }

    private RangeFacet deserializeRange(JsonNode node) {
        return Serializer.MAPPER.convertValue((Object)node, RangeFacet.class);
    }
}

