/*
 * Decompiled with CFR 0.152.
 */
package com.loop54.user;

import com.loop54.Utils;
import com.loop54.exceptions.Loop54ArgumentException;
import com.loop54.user.IRemoteClientInfo;
import java.time.LocalDateTime;

public class UserMetaData {
    public String userId;
    public String ipAddress;
    public String userAgent;
    public String referer;
    public static final String USER_ID_COOKIE_KEY = "Loop54User";
    public static final String PROXY_IP_HEADER_NAME = "X-Forwarded-For";

    public UserMetaData() {
    }

    public UserMetaData(String userId) {
        if (userId == null) {
            throw new IllegalArgumentException("User id was null");
        }
        this.userId = userId;
    }

    private static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public void setFromClientInfo(IRemoteClientInfo clientInfo) {
        if (UserMetaData.isNullOrEmpty(this.userId)) {
            this.userId = this.getOrAddUserIdCookie(clientInfo);
        }
        this.assertUserIdNotNull();
        if (UserMetaData.isNullOrEmpty(this.ipAddress)) {
            this.ipAddress = this.getRealIp(clientInfo);
        }
        if (UserMetaData.isNullOrEmpty(this.userAgent)) {
            this.userAgent = clientInfo.getUserAgent();
        }
        if (UserMetaData.isNullOrEmpty(this.referer)) {
            this.referer = clientInfo.getReferrer();
        }
    }

    private void assertUserIdNotNull() {
        if (UserMetaData.isNullOrEmpty(this.userId)) {
            throw new Loop54ArgumentException("UserId is null or empty. Make sure you've implemented the " + IRemoteClientInfo.class.getSimpleName() + " interface properly so that the cookie setting and getting works.");
        }
    }

    private String getOrAddUserIdCookie(IRemoteClientInfo cookieAccessor) {
        String cookieValue = cookieAccessor.getCookie(USER_ID_COOKIE_KEY);
        if (UserMetaData.isNullOrEmpty(cookieValue)) {
            String newUserId = Utils.generateUserId();
            cookieAccessor.setCookie(USER_ID_COOKIE_KEY, newUserId, LocalDateTime.now().plusYears(1L));
            cookieValue = cookieAccessor.getCookie(USER_ID_COOKIE_KEY);
            if (!newUserId.equals(cookieValue)) {
                throw new Loop54ArgumentException("The cookie with the name 'Loop54User' (Value: '" + cookieValue + "') does not match the newly generated userId '" + newUserId + "'. Make sure you've implemented the " + IRemoteClientInfo.class.getSimpleName() + " interface properly so that the cookie setting and getting works.");
            }
        }
        return cookieValue;
    }

    private String getRealIp(IRemoteClientInfo clientInfo) {
        String forwarded = clientInfo.getRequestHeader(PROXY_IP_HEADER_NAME);
        return UserMetaData.isNullOrEmpty(forwarded) ? clientInfo.getRemoteIp() : forwarded;
    }
}

