/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.async.methods;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.Deflater;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.util.Args;

public final class DeflatingAsyncEntityProducer
implements AsyncEntityProducer {
    private static final int IN_BUF = 8192;
    private static final int OUT_BUF = 8192;
    private final AsyncEntityProducer delegate;
    private final String contentType;
    private final Deflater deflater = new Deflater(-1, true);
    private final ByteBuffer pending = ByteBuffer.allocate(8192);
    private final byte[] in = new byte[8192];
    private final AtomicBoolean delegateEnded = new AtomicBoolean(false);
    private boolean finished = false;

    public DeflatingAsyncEntityProducer(AsyncEntityProducer delegate) {
        this.delegate = Args.notNull(delegate, "delegate");
        this.contentType = delegate.getContentType();
        this.pending.flip();
    }

    @Override
    public boolean isRepeatable() {
        return false;
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getContentEncoding() {
        return "deflate";
    }

    @Override
    public boolean isChunked() {
        return true;
    }

    @Override
    public Set<String> getTrailerNames() {
        return Collections.emptySet();
    }

    @Override
    public int available() {
        if (this.pending.hasRemaining()) {
            return this.pending.remaining();
        }
        return this.delegate.available();
    }

    @Override
    public void produce(DataStreamChannel channel) throws IOException {
        if (this.flushPending(channel)) {
            return;
        }
        this.delegate.produce(new InnerChannel(channel));
        if (this.delegateEnded.get() && !this.finished) {
            this.deflater.finish();
            this.deflateToPending();
            this.flushPending(channel);
            if (!this.pending.hasRemaining()) {
                this.finished = true;
                channel.endStream();
            }
        }
    }

    private boolean flushPending(DataStreamChannel ch) throws IOException {
        while (this.pending.hasRemaining()) {
            int written = ch.write(this.pending);
            if (written != 0) continue;
            return true;
        }
        this.pending.clear().flip();
        return false;
    }

    private void deflateToPending() {
        int total;
        this.pending.compact();
        byte[] out = this.pending.array();
        do {
            total = this.deflater.deflate(out, this.pending.position(), this.pending.remaining(), 0);
            this.pending.position(this.pending.position() + total);
            if (this.pending.hasRemaining() || total <= 0) continue;
            ByteBuffer bigger = ByteBuffer.allocate(this.pending.capacity() * 2);
            this.pending.flip();
            bigger.put(this.pending);
            this.pending.clear();
            this.pending.put(bigger);
        } while (total > 0);
        this.pending.flip();
    }

    @Override
    public void failed(Exception cause) {
        this.delegate.failed(cause);
    }

    @Override
    public void releaseResources() {
        this.delegate.releaseResources();
        this.deflater.end();
    }

    private final class InnerChannel
    implements DataStreamChannel {
        private final DataStreamChannel outer;

        InnerChannel(DataStreamChannel outer) {
            this.outer = outer;
        }

        @Override
        public void requestOutput() {
            this.outer.requestOutput();
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            int consumed = 0;
            while (src.hasRemaining()) {
                int chunk = Math.min(src.remaining(), DeflatingAsyncEntityProducer.this.in.length);
                src.get(DeflatingAsyncEntityProducer.this.in, 0, chunk);
                DeflatingAsyncEntityProducer.this.deflater.setInput(DeflatingAsyncEntityProducer.this.in, 0, chunk);
                consumed += chunk;
                DeflatingAsyncEntityProducer.this.deflateToPending();
                if (!DeflatingAsyncEntityProducer.this.flushPending(this.outer)) continue;
                break;
            }
            return consumed;
        }

        @Override
        public void endStream() {
            DeflatingAsyncEntityProducer.this.delegateEnded.set(true);
        }

        @Override
        public void endStream(List<? extends Header> trailers) {
            this.endStream();
        }
    }
}

