/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.routing;

import java.net.InetAddress;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.routing.RoutingSupport;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.net.URIAuthority;

@Contract(threading=ThreadingBehavior.STATELESS)
public class DefaultRoutePlanner
implements HttpRoutePlanner {
    private final SchemePortResolver schemePortResolver;

    public DefaultRoutePlanner(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
    }

    private static boolean sameNamedEndpoint(NamedEndpoint n1, NamedEndpoint n2) {
        if (n1 == null || n2 == null) {
            return false;
        }
        return Objects.equals(n1.getHostName(), n2.getHostName()) && n1.getPort() == n2.getPort();
    }

    @Override
    public final HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
        HttpHost target;
        if (host == null) {
            throw new ProtocolException("Target host is not specified");
        }
        HttpClientContext clientContext = HttpClientContext.cast(context);
        RequestConfig config = clientContext.getRequestConfigOrDefault();
        HttpHost proxy = config.getProxy();
        if (proxy == null) {
            proxy = this.determineProxy(host, context);
        }
        if ((target = RoutingSupport.normalize(host, this.schemePortResolver)).getPort() < 0) {
            throw new ProtocolException("Unroutable protocol scheme: " + target);
        }
        boolean secure = URIScheme.HTTPS.same(target.getSchemeName());
        URIAuthority authority = secure && request != null && !DefaultRoutePlanner.sameNamedEndpoint(request.getAuthority(), host) ? request.getAuthority() : null;
        Path unixDomainSocket = config.getUnixDomainSocket();
        if (unixDomainSocket != null) {
            if (proxy != null) {
                throw new UnsupportedOperationException("Proxies are not supported over Unix domain sockets");
            }
            return new HttpRoute(target, secure, unixDomainSocket);
        }
        InetAddress inetAddress = this.determineLocalAddress(target, context);
        if (proxy == null) {
            return new HttpRoute(target, authority, inetAddress, secure);
        }
        return new HttpRoute(target, authority, inetAddress, proxy, secure);
    }

    @Override
    public final HttpRoute determineRoute(HttpHost host, HttpContext context) throws HttpException {
        return this.determineRoute(host, null, context);
    }

    protected HttpHost determineProxy(HttpHost target, HttpContext context) throws HttpException {
        return null;
    }

    protected InetAddress determineLocalAddress(HttpHost firstHop, HttpContext context) throws HttpException {
        return null;
    }
}

