/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http2.H2ConnectionException;
import org.apache.hc.core5.http2.H2Error;
import org.apache.hc.core5.http2.H2StreamResetException;
import org.apache.hc.core5.http2.frame.StreamIdGenerator;
import org.apache.hc.core5.http2.impl.nio.H2Stream;
import org.apache.hc.core5.http2.impl.nio.H2StreamChannel;
import org.apache.hc.core5.http2.impl.nio.H2StreamHandler;
import org.apache.hc.core5.util.Args;

class H2Streams {
    private final StreamIdGenerator idGenerator;
    private final Map<Integer, H2Stream> streamMap;
    private final Queue<H2Stream> streams;
    private final AtomicInteger lastLocalId;
    private final AtomicInteger lastRemoteId;
    private final AtomicInteger localCount;
    private final AtomicInteger remoteCount;

    public H2Streams(StreamIdGenerator idGenerator) {
        this.idGenerator = Args.notNull(idGenerator, "Stream id generator");
        this.streamMap = new ConcurrentHashMap<Integer, H2Stream>();
        this.streams = new ConcurrentLinkedQueue<H2Stream>();
        this.lastLocalId = new AtomicInteger(0);
        this.lastRemoteId = new AtomicInteger(0);
        this.localCount = new AtomicInteger(0);
        this.remoteCount = new AtomicInteger(0);
    }

    public boolean isEmpty() {
        return this.streams.isEmpty();
    }

    public Iterator<H2Stream> iterator() {
        return this.streams.iterator();
    }

    public int getLastLocalId() {
        return this.lastLocalId.get();
    }

    public int getLastRemoteId() {
        return this.lastRemoteId.get();
    }

    public int getLocalCount() {
        return this.localCount.get();
    }

    public int getRemoteCount() {
        return this.remoteCount.get();
    }

    private H2Stream createStream(H2StreamChannel channel, H2StreamHandler streamHandler) {
        int currentId;
        int streamId = channel.getId();
        boolean remoteStream = this.isOtherSide(streamId);
        H2Stream stream = new H2Stream(channel, streamHandler, state -> {
            AtomicInteger count = remoteStream ? this.remoteCount : this.localCount;
            switch (state) {
                case OPEN: {
                    count.incrementAndGet();
                    break;
                }
                case CLOSED: {
                    count.decrementAndGet();
                }
            }
        });
        if (remoteStream && streamId > (currentId = this.lastRemoteId.get())) {
            this.lastRemoteId.compareAndSet(currentId, streamId);
        }
        this.streamMap.put(streamId, stream);
        this.streams.add(stream);
        return stream;
    }

    public H2Stream createActive(H2StreamChannel channel, H2StreamHandler streamHandler) {
        H2Stream stream = this.createStream(channel, streamHandler);
        if (!stream.isClosed()) {
            stream.activate();
        }
        return stream;
    }

    public H2Stream createReserved(H2StreamChannel channel, H2StreamHandler streamHandler) {
        return this.createStream(channel, streamHandler);
    }

    public void resetIfExceedsMaxConcurrentLimit(H2Stream stream, int max) throws IOException {
        if (stream.isActive() && this.getRemoteCount() > max) {
            stream.localReset(new H2StreamResetException(H2Error.REFUSED_STREAM, "Local SETTINGS_MAX_CONCURRENT_STREAMS exceeded"));
        }
    }

    public void dropStreamId(int streamId) {
        this.streamMap.remove(streamId);
    }

    public void shutdownAndReleaseAll() {
        for (H2Stream stream : this.streams) {
            if (stream.isClosed()) {
                stream.releaseResources();
                continue;
            }
            stream.fail(new ConnectionClosedException());
        }
        this.streams.clear();
        this.streamMap.clear();
    }

    public H2Stream lookup(int streamId) {
        return this.streamMap.get(streamId);
    }

    boolean hasBeenSeen(int streamId) {
        return streamId <= (this.isSameSide(streamId) ? this.lastLocalId : this.lastRemoteId).get();
    }

    boolean isClosed(H2Stream stream, int streamId) {
        return stream != null ? stream.isLocalClosed() && stream.isRemoteClosed() : this.hasBeenSeen(streamId);
    }

    public H2Stream lookupValidOrNull(int streamId) throws H2ConnectionException {
        H2Stream stream = this.streamMap.get(streamId);
        if (this.isClosed(stream, streamId)) {
            throw new H2ConnectionException(H2Error.STREAM_CLOSED, "Stream closed");
        }
        return stream;
    }

    public H2Stream lookupSeen(int streamId) throws H2ConnectionException {
        H2Stream stream = this.streamMap.get(streamId);
        if (stream == null && !this.hasBeenSeen(streamId)) {
            throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Unexpected stream id: " + streamId);
        }
        return stream;
    }

    public H2Stream lookupValid(int streamId) throws H2ConnectionException {
        H2Stream stream = this.lookupValidOrNull(streamId);
        if (stream == null) {
            throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Unexpected stream id: " + streamId);
        }
        return stream;
    }

    public boolean isSameSide(int streamId) {
        return this.idGenerator.isSameSide(streamId);
    }

    public boolean isOtherSide(int streamId) {
        return !this.idGenerator.isSameSide(streamId);
    }

    public int generateStreamId() {
        int newStreamId;
        int currentId;
        while (!this.lastLocalId.compareAndSet(currentId = this.lastLocalId.get(), newStreamId = this.idGenerator.generate(currentId))) {
        }
        return newStreamId;
    }
}

