/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.priority;

import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BufferedHeader;
import org.apache.hc.core5.http2.priority.PriorityValue;
import org.apache.hc.core5.util.CharArrayBuffer;

@Internal
public final class PriorityFormatter {
    private PriorityFormatter() {
    }

    public static void format(CharArrayBuffer dst, PriorityValue value) {
        if (value == null) {
            return;
        }
        boolean urgencyPresent = false;
        if (value.getUrgency() != 3) {
            dst.append("u=");
            dst.append(value.getUrgency());
            urgencyPresent = true;
        }
        if (value.isIncremental()) {
            if (urgencyPresent) {
                dst.append(", ");
            }
            dst.append("i");
        }
    }

    public static String format(PriorityValue value) {
        if (value == null) {
            return null;
        }
        CharArrayBuffer buf = new CharArrayBuffer(16);
        PriorityFormatter.format(buf, value);
        return buf.toString();
    }

    public static Header formatHeader(PriorityValue value) {
        if (value == null) {
            return new BasicHeader("Priority", null);
        }
        CharArrayBuffer buf = new CharArrayBuffer(16);
        buf.append("Priority");
        buf.append(": ");
        PriorityFormatter.format(buf, value);
        return BufferedHeader.create(buf);
    }
}

