/*
 * Decompiled with CFR 0.152.
 */
package com.loop54.spring;

import com.loop54.user.IRemoteClientInfo;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import org.springframework.web.context.request.ServletRequestAttributes;

public class SpringRemoteClientInfo
implements IRemoteClientInfo {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final Map<String, Cookie> cookieMap = new HashMap<String, Cookie>();

    public SpringRemoteClientInfo(ServletRequestAttributes requestAttributes) {
        this.request = requestAttributes.getRequest();
        this.response = requestAttributes.getResponse();
        Cookie[] requestCookies = this.request.getCookies();
        if (requestCookies != null) {
            for (Cookie cookie : requestCookies) {
                this.cookieMap.put(cookie.getName(), cookie);
            }
        }
    }

    public String getRequestHeader(String name) {
        return this.request.getHeader(name);
    }

    public String getReferrer() {
        return this.request.getHeader("referer");
    }

    public String getUserAgent() {
        return this.request.getHeader("user-agent");
    }

    public String getRemoteIp() {
        return this.request.getRemoteAddr();
    }

    public String getCookie(String name) {
        Cookie cookie = this.cookieMap.get(name);
        if (cookie == null) {
            return null;
        }
        return cookie.getValue();
    }

    public void setCookie(String name, String value, LocalDateTime expiryTime) {
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge((int)ChronoUnit.SECONDS.between(LocalDateTime.now(), expiryTime));
        this.response.addCookie(cookie);
        this.cookieMap.put(name, cookie);
    }
}

