/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.SettableAnyProperty;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.deser.impl.PropertyValue;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public final class PropertyBasedCreator {
    protected final int _propertyCount;
    protected final ValueInstantiator _valueInstantiator;
    protected final HashMap<String, SettableBeanProperty> _propertyLookup;
    protected final SettableBeanProperty[] _allProperties;
    protected final BitSet _injectablePropIndexes;

    protected PropertyBasedCreator(DeserializationContext ctxt, ValueInstantiator valueInstantiator, SettableBeanProperty[] creatorProps, boolean caseInsensitive, boolean addAliases) {
        int len;
        this._valueInstantiator = valueInstantiator;
        this._propertyLookup = caseInsensitive ? CaseInsensitiveMap.construct(ctxt.getConfig().getLocale()) : new HashMap();
        if (addAliases) {
            DeserializationConfig config = ctxt.getConfig();
            for (SettableBeanProperty prop : creatorProps) {
                List<PropertyName> aliases;
                if (prop.isIgnorable() || (aliases = prop.findAliases(config)).isEmpty()) continue;
                for (PropertyName pn : aliases) {
                    this._propertyLookup.put(pn.getSimpleName(), prop);
                }
            }
        }
        this._propertyCount = len = creatorProps.length;
        this._allProperties = new SettableBeanProperty[len];
        BitSet injectablePropIndexes = null;
        for (int i2 = 0; i2 < len; ++i2) {
            SettableBeanProperty prop;
            this._allProperties[i2] = prop = creatorProps[i2];
            if (!prop.isIgnorable()) {
                this._propertyLookup.put(prop.getName(), prop);
            }
            if (prop.getInjectionDefinition() == null) continue;
            if (injectablePropIndexes == null) {
                injectablePropIndexes = new BitSet(len);
            }
            injectablePropIndexes.set(i2);
        }
        this._injectablePropIndexes = injectablePropIndexes;
    }

    protected PropertyBasedCreator(PropertyBasedCreator base, HashMap<String, SettableBeanProperty> propertyLookup, SettableBeanProperty[] allProperties) {
        this._propertyCount = base._propertyCount;
        this._valueInstantiator = base._valueInstantiator;
        this._injectablePropIndexes = base._injectablePropIndexes;
        this._propertyLookup = propertyLookup;
        this._allProperties = allProperties;
    }

    public static PropertyBasedCreator construct(DeserializationContext ctxt, ValueInstantiator valueInstantiator, SettableBeanProperty[] srcCreatorProps, BeanPropertyMap allProperties) throws JsonMappingException {
        int len = srcCreatorProps.length;
        SettableBeanProperty[] creatorProps = new SettableBeanProperty[len];
        for (int i2 = 0; i2 < len; ++i2) {
            SettableBeanProperty prop = srcCreatorProps[i2];
            if (!prop.hasValueDeserializer() && !prop.isInjectionOnly()) {
                prop = prop.withValueDeserializer(ctxt.findContextualValueDeserializer(prop.getType(), prop));
            }
            creatorProps[i2] = prop;
        }
        return new PropertyBasedCreator(ctxt, valueInstantiator, creatorProps, allProperties.isCaseInsensitive(), true);
    }

    public static PropertyBasedCreator construct(DeserializationContext ctxt, ValueInstantiator valueInstantiator, SettableBeanProperty[] srcCreatorProps, boolean caseInsensitive) throws JsonMappingException {
        int len = srcCreatorProps.length;
        SettableBeanProperty[] creatorProps = new SettableBeanProperty[len];
        for (int i2 = 0; i2 < len; ++i2) {
            SettableBeanProperty prop = srcCreatorProps[i2];
            if (!prop.hasValueDeserializer()) {
                prop = prop.withValueDeserializer(ctxt.findContextualValueDeserializer(prop.getType(), prop));
            }
            creatorProps[i2] = prop;
        }
        return new PropertyBasedCreator(ctxt, valueInstantiator, creatorProps, caseInsensitive, false);
    }

    public PropertyBasedCreator renameAll(NameTransformer transformer) {
        if (transformer == null || transformer == NameTransformer.NOP) {
            return this;
        }
        int len = this._allProperties.length;
        HashMap<String, SettableBeanProperty> newLookup = new HashMap<String, SettableBeanProperty>(this._propertyLookup);
        ArrayList<SettableBeanProperty> newProps = new ArrayList<SettableBeanProperty>(len);
        for (SettableBeanProperty prop : this._allProperties) {
            if (prop == null) {
                newProps.add(null);
                continue;
            }
            SettableBeanProperty renamedProperty = prop.unwrapped(transformer);
            String oldName = prop.getName();
            String newName = renamedProperty.getName();
            newProps.add(renamedProperty);
            if (oldName.equals(newName) || !newLookup.containsKey(oldName)) continue;
            newLookup.remove(oldName);
            newLookup.put(newName, renamedProperty);
        }
        return new PropertyBasedCreator(this, newLookup, newProps.toArray(new SettableBeanProperty[0]));
    }

    public Collection<SettableBeanProperty> properties() {
        return this._propertyLookup.values();
    }

    public SettableBeanProperty findCreatorProperty(String name) {
        return this._propertyLookup.get(name);
    }

    public SettableBeanProperty findCreatorProperty(int propertyIndex) {
        for (SettableBeanProperty prop : this._propertyLookup.values()) {
            if (prop.getPropertyIndex() != propertyIndex) continue;
            return prop;
        }
        return null;
    }

    public PropertyValueBuffer startBuilding(JsonParser p, DeserializationContext ctxt, ObjectIdReader oir) {
        return new PropertyValueBuffer(p, ctxt, this._propertyCount, oir, null, this._injectablePropIndexes);
    }

    public PropertyValueBuffer startBuildingWithAnySetter(JsonParser p, DeserializationContext ctxt, ObjectIdReader oir, SettableAnyProperty anySetter) {
        return new PropertyValueBuffer(p, ctxt, this._propertyCount, oir, anySetter, this._injectablePropIndexes);
    }

    public Object build(DeserializationContext ctxt, PropertyValueBuffer buffer) throws IOException {
        Object bean = this._valueInstantiator.createFromObjectWith(ctxt, this._allProperties, buffer);
        if (bean != null) {
            bean = buffer.handleIdValue(ctxt, bean);
            PropertyValue pv = buffer.buffered();
            while (pv != null) {
                pv.assign(ctxt, bean);
                pv = pv.next;
            }
        }
        return bean;
    }

    static class CaseInsensitiveMap
    extends HashMap<String, SettableBeanProperty> {
        private static final long serialVersionUID = 1L;
        protected final Locale _locale;

        public CaseInsensitiveMap(Locale l) {
            this._locale = l;
        }

        public static CaseInsensitiveMap construct(Locale l) {
            return new CaseInsensitiveMap(l);
        }

        @Override
        public SettableBeanProperty get(Object key0) {
            return (SettableBeanProperty)super.get(((String)key0).toLowerCase(this._locale));
        }

        @Override
        public SettableBeanProperty put(String key, SettableBeanProperty value) {
            key = key.toLowerCase(this._locale);
            return super.put(key, value);
        }
    }
}

