/*
 * Decompiled with CFR 0.152.
 */
package com.loop54.model;

import com.loop54.model.EntityAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Entity {
    public String type;
    public String id;
    private Map<String, EntityAttribute> internalAttributeMapping;

    private Entity() {
    }

    public Entity(String type, String id) {
        if (type == null) {
            throw new IllegalArgumentException("Type was null");
        }
        if (id == null) {
            throw new IllegalArgumentException("Id was null");
        }
        this.type = type;
        this.id = id;
    }

    public List<EntityAttribute> getAttributes() {
        return this.internalAttributeMapping == null ? null : this.internalAttributeMapping.values().stream().collect(Collectors.toList());
    }

    public void setAttributes(List<EntityAttribute> attributes) {
        this.internalAttributeMapping = new HashMap<String, EntityAttribute>();
        for (EntityAttribute attribute : attributes) {
            this.internalAttributeMapping.put(attribute.getName().toLowerCase(), attribute);
        }
    }

    public <T> T getAttributeValueOrNull(String name, Class<T> clazz) {
        List<T> attributeValues = this.getAttributeValuesOrNull(name, clazz);
        if (attributeValues == null || attributeValues.size() == 0) {
            return null;
        }
        return attributeValues.get(0);
    }

    public <T> List<T> getAttributeValuesOrNull(String name, Class<T> clazz) {
        if (name == null) {
            throw new IllegalArgumentException("Name was null");
        }
        EntityAttribute attribute = this.internalAttributeMapping.get(name);
        return attribute == null ? null : attribute.getValues(clazz);
    }
}

