/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.async.methods;

import com.aayushatharva.brotli4j.encoder.Encoder;
import com.aayushatharva.brotli4j.encoder.EncoderJNI;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.util.Args;

public final class DeflatingBrotliEntityProducer
implements AsyncEntityProducer {
    private final AsyncEntityProducer upstream;
    private final EncoderJNI.Wrapper encoder;
    private ByteBuffer pendingOut;
    private List<? extends Header> pendingTrailers;
    private State state = State.STREAMING;

    public DeflatingBrotliEntityProducer(AsyncEntityProducer upstream, int quality, int lgwin, Encoder.Mode mode) throws IOException {
        this.upstream = Args.notNull(upstream, "upstream");
        this.encoder = new EncoderJNI.Wrapper(262144, quality, lgwin, mode);
    }

    public DeflatingBrotliEntityProducer(AsyncEntityProducer upstream, int quality, int lgwin, int modeInt) throws IOException {
        this(upstream, quality, lgwin, modeInt == 1 ? Encoder.Mode.TEXT : (modeInt == 2 ? Encoder.Mode.FONT : Encoder.Mode.GENERIC));
    }

    public DeflatingBrotliEntityProducer(AsyncEntityProducer upstream) throws IOException {
        this(upstream, 5, 22, Encoder.Mode.GENERIC);
    }

    @Override
    public String getContentType() {
        return this.upstream.getContentType();
    }

    @Override
    public String getContentEncoding() {
        return "br";
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public boolean isChunked() {
        return true;
    }

    @Override
    public Set<String> getTrailerNames() {
        return this.upstream.getTrailerNames();
    }

    @Override
    public boolean isRepeatable() {
        return this.upstream.isRepeatable();
    }

    @Override
    public int available() {
        if (this.state == State.DONE) {
            return 0;
        }
        if (this.pendingOut != null && this.pendingOut.hasRemaining() || this.pendingTrailers != null) {
            return 1;
        }
        int up = this.upstream.available();
        return this.state != State.STREAMING || up > 0 ? 1 : 0;
    }

    @Override
    public void produce(final DataStreamChannel channel) throws IOException {
        if (this.flushPending(channel)) {
            return;
        }
        if (this.state == State.FINISHING) {
            this.encoder.push(EncoderJNI.Operation.FINISH, 0);
            if (this.drainEncoder(channel)) {
                return;
            }
            if (this.pendingTrailers == null) {
                this.pendingTrailers = Collections.emptyList();
            }
            channel.endStream(this.pendingTrailers);
            this.pendingTrailers = null;
            this.state = State.DONE;
            return;
        }
        this.upstream.produce(new DataStreamChannel(){

            @Override
            public void requestOutput() {
                channel.requestOutput();
            }

            @Override
            public int write(ByteBuffer src) throws IOException {
                int accepted = 0;
                while (src.hasRemaining()) {
                    ByteBuffer in = DeflatingBrotliEntityProducer.this.encoder.getInputBuffer();
                    if (!in.hasRemaining()) {
                        DeflatingBrotliEntityProducer.this.encoder.push(EncoderJNI.Operation.PROCESS, 0);
                        if (!DeflatingBrotliEntityProducer.this.drainEncoder(channel)) continue;
                        break;
                    }
                    int xfer = Math.min(src.remaining(), in.remaining());
                    int lim = src.limit();
                    src.limit(src.position() + xfer);
                    in.put(src);
                    src.limit(lim);
                    accepted += xfer;
                    DeflatingBrotliEntityProducer.this.encoder.push(EncoderJNI.Operation.PROCESS, xfer);
                    if (!DeflatingBrotliEntityProducer.this.drainEncoder(channel)) continue;
                    break;
                }
                return accepted;
            }

            @Override
            public void endStream() throws IOException {
                this.endStream(Collections.emptyList());
            }

            @Override
            public void endStream(List<? extends Header> trailers) throws IOException {
                DeflatingBrotliEntityProducer.this.pendingTrailers = trailers;
                DeflatingBrotliEntityProducer.this.state = State.FINISHING;
                DeflatingBrotliEntityProducer.this.encoder.push(EncoderJNI.Operation.FINISH, 0);
                if (DeflatingBrotliEntityProducer.this.drainEncoder(channel)) {
                    return;
                }
                if (DeflatingBrotliEntityProducer.this.pendingTrailers == null) {
                    DeflatingBrotliEntityProducer.this.pendingTrailers = Collections.emptyList();
                }
                channel.endStream(DeflatingBrotliEntityProducer.this.pendingTrailers);
                DeflatingBrotliEntityProducer.this.pendingTrailers = null;
                DeflatingBrotliEntityProducer.this.state = State.DONE;
            }
        });
    }

    @Override
    public void failed(Exception cause) {
        this.upstream.failed(cause);
    }

    @Override
    public void releaseResources() {
        try {
            this.encoder.destroy();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.upstream.releaseResources();
        this.pendingOut = null;
        this.pendingTrailers = null;
        this.state = State.DONE;
    }

    private boolean flushPending(DataStreamChannel channel) throws IOException {
        if (this.pendingOut != null && this.pendingOut.hasRemaining()) {
            channel.write(this.pendingOut);
            if (this.pendingOut.hasRemaining()) {
                channel.requestOutput();
                return true;
            }
            this.pendingOut = null;
        }
        if (this.pendingOut == null && this.pendingTrailers != null && this.state != State.STREAMING) {
            channel.endStream(this.pendingTrailers);
            this.pendingTrailers = null;
            this.state = State.DONE;
            return true;
        }
        return false;
    }

    private boolean drainEncoder(DataStreamChannel channel) throws IOException {
        while (this.encoder.hasMoreOutput()) {
            ByteBuffer buf = this.encoder.pull();
            if (buf == null || !buf.hasRemaining()) continue;
            channel.write(buf);
            if (!buf.hasRemaining()) continue;
            this.pendingOut = ByteBuffer.allocateDirect(buf.remaining());
            this.pendingOut.put(buf).flip();
            channel.requestOutput();
            return true;
        }
        return false;
    }

    private static enum State {
        STREAMING,
        FINISHING,
        DONE;

    }
}

