/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.HttpEntityWrapper;
import org.apache.hc.core5.io.IOFunction;
import org.apache.hc.core5.util.Args;

public final class CompressingEntity
extends HttpEntityWrapper {
    private final IOFunction<OutputStream, OutputStream> encoder;
    private final String coding;

    public CompressingEntity(HttpEntity src, String coding, IOFunction<OutputStream, OutputStream> encoder) {
        super(src);
        this.encoder = Args.notNull(encoder, "Stream encoder");
        this.coding = Args.notNull(coding, "Content coding").toLowerCase(Locale.ROOT);
    }

    @Override
    public String getContentEncoding() {
        return this.coding;
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public boolean isChunked() {
        return true;
    }

    @Override
    public InputStream getContent() {
        throw new UnsupportedOperationException("Compressed entity is write-only");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream out) throws IOException {
        Args.notNull(out, "Output stream");
        OutputStream wrapped = this.encoder.apply(out);
        try {
            super.writeTo(wrapped);
        }
        finally {
            try {
                wrapped.close();
            }
            catch (IOException iOException) {}
        }
    }
}

