/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.hc.client5.http.async.AsyncExecChain;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.apache.hc.client5.http.async.methods.InflatingAsyncDataConsumer;
import org.apache.hc.client5.http.async.methods.InflatingBrotliDataConsumer;
import org.apache.hc.client5.http.async.methods.InflatingGzipDataConsumer;
import org.apache.hc.client5.http.async.methods.InflatingZstdDataConsumer;
import org.apache.hc.client5.http.entity.compress.ContentCoding;
import org.apache.hc.client5.http.impl.Brotli4jRuntime;
import org.apache.hc.client5.http.impl.ContentCodingSupport;
import org.apache.hc.client5.http.impl.ZstdRuntime;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.http.nio.AsyncDataConsumer;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.STATELESS)
@Internal
public final class ContentCompressionAsyncExec
implements AsyncExecChainHandler {
    private final Lookup<UnaryOperator<AsyncDataConsumer>> decoders;
    private final List<String> acceptTokens;
    private final int maxCodecListLen;

    public ContentCompressionAsyncExec(LinkedHashMap<String, UnaryOperator<AsyncDataConsumer>> decoderMap, int maxCodecListLen) {
        Args.notEmpty(decoderMap, "Decoder map");
        RegistryBuilder rb = RegistryBuilder.create();
        decoderMap.forEach(rb::register);
        this.decoders = rb.build();
        this.acceptTokens = new ArrayList<String>(decoderMap.keySet());
        this.maxCodecListLen = maxCodecListLen;
    }

    public ContentCompressionAsyncExec(LinkedHashMap<String, UnaryOperator<AsyncDataConsumer>> decoderMap) {
        this(decoderMap, 5);
    }

    public ContentCompressionAsyncExec(int maxCodecListLen) {
        LinkedHashMap<String, UnaryOperator> map = new LinkedHashMap<String, UnaryOperator>();
        map.put(ContentCoding.DEFLATE.token(), d -> new InflatingAsyncDataConsumer((AsyncDataConsumer)d, null));
        map.put(ContentCoding.GZIP.token(), InflatingGzipDataConsumer::new);
        map.put(ContentCoding.X_GZIP.token(), InflatingGzipDataConsumer::new);
        RegistryBuilder<UnaryOperator> rb = RegistryBuilder.create().register(ContentCoding.GZIP.token(), InflatingGzipDataConsumer::new).register(ContentCoding.X_GZIP.token(), InflatingGzipDataConsumer::new).register(ContentCoding.DEFLATE.token(), d -> new InflatingAsyncDataConsumer((AsyncDataConsumer)d, null));
        ArrayList<String> tokens = new ArrayList<String>(Arrays.asList("gzip", "x-gzip", "deflate"));
        if (ZstdRuntime.available()) {
            rb.register(ContentCoding.ZSTD.token(), InflatingZstdDataConsumer::new);
            tokens.add("zstd");
        }
        if (Brotli4jRuntime.available()) {
            rb.register(ContentCoding.BROTLI.token(), InflatingBrotliDataConsumer::new);
            tokens.add(ContentCoding.BROTLI.token());
        }
        this.decoders = rb.build();
        this.acceptTokens = tokens;
        this.maxCodecListLen = maxCodecListLen;
    }

    public ContentCompressionAsyncExec() {
        this(5);
    }

    @Override
    public void execute(HttpRequest request, AsyncEntityProducer producer, AsyncExecChain.Scope scope, AsyncExecChain chain, final AsyncExecCallback cb) throws IOException, HttpException {
        HttpClientContext ctx = scope != null ? scope.clientContext : HttpClientContext.create();
        final boolean enabled = ctx.getRequestConfigOrDefault().isContentCompressionEnabled();
        if (enabled && !request.containsHeader("Accept-Encoding")) {
            request.addHeader(MessageSupport.headerOfTokens("Accept-Encoding", this.acceptTokens));
        }
        chain.proceed(request, producer, scope, new AsyncExecCallback(){

            @Override
            public AsyncDataConsumer handleResponse(HttpResponse rsp, EntityDetails details) throws HttpException, IOException {
                if (!enabled) {
                    return cb.handleResponse(rsp, details);
                }
                List<String> codecs = ContentCodingSupport.parseContentCodecs(details);
                ContentCodingSupport.validate(codecs, ContentCompressionAsyncExec.this.maxCodecListLen);
                if (!codecs.isEmpty()) {
                    AsyncDataConsumer downstream = cb.handleResponse(rsp, ContentCompressionAsyncExec.wrapEntityDetails(details));
                    for (int i2 = codecs.size() - 1; i2 >= 0; --i2) {
                        String codec = codecs.get(i2);
                        UnaryOperator op = (UnaryOperator)ContentCompressionAsyncExec.this.decoders.lookup(codec);
                        if (op == null) {
                            throw new HttpException("Unsupported Content-Encoding: " + codec);
                        }
                        downstream = (AsyncDataConsumer)op.apply(downstream);
                    }
                    return downstream;
                }
                return cb.handleResponse(rsp, details);
            }

            @Override
            public void handleInformationResponse(HttpResponse r) throws HttpException, IOException {
                cb.handleInformationResponse(r);
            }

            @Override
            public void completed() {
                cb.completed();
            }

            @Override
            public void failed(Exception ex) {
                cb.failed(ex);
            }
        });
    }

    private static EntityDetails wrapEntityDetails(final EntityDetails original) {
        return new EntityDetails(){

            @Override
            public long getContentLength() {
                return -1L;
            }

            @Override
            public String getContentType() {
                return original.getContentType();
            }

            @Override
            public String getContentEncoding() {
                return null;
            }

            @Override
            public boolean isChunked() {
                return true;
            }

            @Override
            public Set<String> getTrailerNames() {
                return original.getTrailerNames();
            }
        };
    }
}

