/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.frame;

public enum FrameType {
    DATA(0),
    HEADERS(1),
    PRIORITY(2),
    RST_STREAM(3),
    SETTINGS(4),
    PUSH_PROMISE(5),
    PING(6),
    GOAWAY(7),
    WINDOW_UPDATE(8),
    CONTINUATION(9),
    PRIORITY_UPDATE(16);

    final int value;
    private static final FrameType[] LOOKUP_TABLE;

    private FrameType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static FrameType valueOf(int value) {
        if (value < 0 || value >= LOOKUP_TABLE.length) {
            return null;
        }
        return LOOKUP_TABLE[value];
    }

    public static String toString(int value) {
        if (value < 0 || value >= LOOKUP_TABLE.length) {
            return Integer.toString(value);
        }
        FrameType t = LOOKUP_TABLE[value];
        return t != null ? t.name() : Integer.toString(value);
    }

    public boolean same(int rawType) {
        return this.value == rawType;
    }

    static {
        int max = -1;
        for (FrameType t : FrameType.values()) {
            if (t.value <= max) continue;
            max = t.value;
        }
        LOOKUP_TABLE = new FrameType[max + 1];
        FrameType[] frameTypeArray = FrameType.values();
        int n = frameTypeArray.length;
        for (int j = 0; j < n; ++j) {
            FrameType t;
            FrameType.LOOKUP_TABLE[t.value] = t = frameTypeArray[j];
        }
    }
}

