/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.priority;

import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http2.priority.PriorityValue;

@Internal
public final class PriorityParams {
    private final Integer urgency;
    private final Boolean incremental;

    public PriorityParams(Integer urgency, Boolean incremental) {
        if (urgency != null && (urgency < 0 || urgency > 7)) {
            throw new IllegalArgumentException("urgency out of range [0..7]: " + urgency);
        }
        this.urgency = urgency;
        this.incremental = incremental;
    }

    public Integer getUrgency() {
        return this.urgency;
    }

    public Boolean getIncremental() {
        return this.incremental;
    }

    public PriorityValue toValueWithDefaults() {
        int u = this.urgency != null ? this.urgency : 3;
        boolean i2 = this.incremental != null ? this.incremental : false;
        return PriorityValue.of(u, i2);
    }
}

