/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.priority;

import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.http.message.ParserCursor;
import org.apache.hc.core5.http2.priority.PriorityParams;
import org.apache.hc.core5.util.Tokenizer;

@Internal
public final class PriorityParamsParser {
    private static final Tokenizer TK = Tokenizer.INSTANCE;
    private static final Tokenizer.Delimiter KEY_DELIMS = Tokenizer.delimiters('=', ',', ';');
    private static final Tokenizer.Delimiter VALUE_DELIMS = Tokenizer.delimiters(',', ';');

    private PriorityParamsParser() {
    }

    public static PriorityParams parse(CharSequence src, ParserCursor c) {
        Integer u = null;
        Boolean i2 = null;
        while (!c.atEnd()) {
            char ch;
            TK.skipWhiteSpace(src, c);
            if (c.atEnd()) break;
            String k = TK.parseToken(src, (Tokenizer.Cursor)c, KEY_DELIMS);
            if (k == null || k.isEmpty()) {
                PriorityParamsParser.skipToNextItem(src, c);
                continue;
            }
            TK.skipWhiteSpace(src, c);
            char c2 = ch = c.atEnd() ? (char)'\u0000' : src.charAt(c.getPos());
            if (ch == '=') {
                int v2;
                c.updatePos(c.getPos() + 1);
                TK.skipWhiteSpace(src, c);
                if ("u".equalsIgnoreCase(k)) {
                    String t = TK.parseToken(src, (Tokenizer.Cursor)c, VALUE_DELIMS);
                    try {
                        v2 = Integer.parseInt(t);
                        if (v2 >= 0 && v2 <= 7) {
                            u = v2;
                        }
                    }
                    catch (Exception v2) {}
                } else if ("i".equalsIgnoreCase(k)) {
                    char b;
                    char c3 = b = c.atEnd() ? (char)'\u0000' : src.charAt(c.getPos());
                    if (b == '?') {
                        c.updatePos(c.getPos() + 1);
                        int n = v2 = c.atEnd() ? 0 : (int)src.charAt(c.getPos());
                        if (v2 == 49) {
                            i2 = Boolean.TRUE;
                            c.updatePos(c.getPos() + 1);
                        } else if (v2 == 48) {
                            i2 = Boolean.FALSE;
                            c.updatePos(c.getPos() + 1);
                        }
                    } else {
                        String t = TK.parseToken(src, (Tokenizer.Cursor)c, VALUE_DELIMS);
                        if ("1".equals(t)) {
                            i2 = Boolean.TRUE;
                        } else if ("0".equals(t)) {
                            i2 = Boolean.FALSE;
                        }
                    }
                } else {
                    TK.parseToken(src, (Tokenizer.Cursor)c, VALUE_DELIMS);
                }
                PriorityParamsParser.skipParamsThenNextItem(src, c);
                continue;
            }
            if ("i".equalsIgnoreCase(k)) {
                i2 = Boolean.TRUE;
            }
            PriorityParamsParser.skipParamsThenNextItem(src, c);
        }
        return new PriorityParams(u, i2);
    }

    public static PriorityParams parse(String value) {
        if (value == null || value.isEmpty()) {
            return new PriorityParams(null, null);
        }
        ParserCursor c = new ParserCursor(0, value.length());
        return PriorityParamsParser.parse(value, c);
    }

    public static PriorityParams parse(Header header) {
        if (header == null) {
            return new PriorityParams(null, null);
        }
        PriorityParams[] box = new PriorityParams[1];
        MessageSupport.parseHeader(header, (seq, cur) -> {
            box[0] = PriorityParamsParser.parse(seq, cur);
        });
        return box[0] != null ? box[0] : new PriorityParams(null, null);
    }

    private static void skipToNextItem(CharSequence buf, ParserCursor c) {
        while (!c.atEnd()) {
            char ch = buf.charAt(c.getPos());
            c.updatePos(c.getPos() + 1);
            if (ch != ',') continue;
            break;
        }
    }

    private static void skipParamsThenNextItem(CharSequence buf, ParserCursor c) {
        int pos;
        char ch;
        while (!c.atEnd() && (ch = buf.charAt(pos = c.getPos())) == ';') {
            c.updatePos(pos + 1);
            TK.parseToken(buf, (Tokenizer.Cursor)c, VALUE_DELIMS);
        }
        while (!c.atEnd()) {
            char ch2 = buf.charAt(c.getPos());
            if (ch2 == ',') {
                c.updatePos(c.getPos() + 1);
                break;
            }
            c.updatePos(c.getPos() + 1);
        }
    }
}

