/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.protocol;

import java.io.IOException;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class H2ResponseConformance
implements HttpResponseInterceptor {
    public static final H2ResponseConformance INSTANCE = new H2ResponseConformance();
    private final String[] illegalHeaderNames;

    @Internal
    public H2ResponseConformance(String ... illegalHeaderNames) {
        this.illegalHeaderNames = illegalHeaderNames;
    }

    public H2ResponseConformance() {
        this("Connection", "Keep-Alive", "Transfer-Encoding", "Upgrade");
    }

    @Override
    public void process(HttpResponse response, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        for (int i2 = 0; i2 < this.illegalHeaderNames.length; ++i2) {
            String headerName = this.illegalHeaderNames[i2];
            Header header = response.getFirstHeader(headerName);
            if (header == null) continue;
            throw new ProtocolException("Header '%s' is illegal for HTTP/2 messages", headerName);
        }
    }
}

