/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.util.Comparator;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class TypedStringValue
implements BeanMetadataElement,
Comparable<TypedStringValue> {
    private @Nullable String value;
    private volatile @Nullable Object targetType;
    private @Nullable Object source;
    private @Nullable String specifiedTypeName;
    private volatile boolean dynamic;

    public TypedStringValue(@Nullable String value) {
        this.setValue(value);
    }

    public TypedStringValue(@Nullable String value, Class<?> targetType) {
        this.setValue(value);
        this.setTargetType(targetType);
    }

    public TypedStringValue(@Nullable String value, String targetTypeName) {
        this.setValue(value);
        this.setTargetTypeName(targetTypeName);
    }

    public void setValue(@Nullable String value) {
        this.value = value;
    }

    public @Nullable String getValue() {
        return this.value;
    }

    public void setTargetType(Class<?> targetType) {
        Assert.notNull(targetType, "'targetType' must not be null");
        this.targetType = targetType;
    }

    public Class<?> getTargetType() {
        Object targetTypeValue = this.targetType;
        if (!(targetTypeValue instanceof Class)) {
            throw new IllegalStateException("Typed String value does not carry a resolved target type");
        }
        Class clazz = (Class)targetTypeValue;
        return clazz;
    }

    public void setTargetTypeName(@Nullable String targetTypeName) {
        this.targetType = targetTypeName;
    }

    public @Nullable String getTargetTypeName() {
        Object targetTypeValue = this.targetType;
        if (targetTypeValue instanceof Class) {
            Class clazz = (Class)targetTypeValue;
            return clazz.getName();
        }
        return (String)targetTypeValue;
    }

    public boolean hasTargetType() {
        return this.targetType instanceof Class;
    }

    public @Nullable Class<?> resolveTargetType(@Nullable ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> resolvedClass;
        String typeName = this.getTargetTypeName();
        if (typeName == null) {
            return null;
        }
        this.targetType = resolvedClass = ClassUtils.forName(typeName, classLoader);
        return resolvedClass;
    }

    public void setSource(@Nullable Object source) {
        this.source = source;
    }

    @Override
    public @Nullable Object getSource() {
        return this.source;
    }

    public void setSpecifiedTypeName(@Nullable String specifiedTypeName) {
        this.specifiedTypeName = specifiedTypeName;
    }

    public @Nullable String getSpecifiedTypeName() {
        return this.specifiedTypeName;
    }

    public void setDynamic() {
        this.dynamic = true;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    @Override
    public int compareTo(@Nullable TypedStringValue o) {
        return Comparator.comparing(TypedStringValue::getValue).compare(this, o);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof TypedStringValue)) return false;
        TypedStringValue that = (TypedStringValue)other;
        if (!ObjectUtils.nullSafeEquals(this.value, that.value)) return false;
        if (!ObjectUtils.nullSafeEquals(this.targetType, that.targetType)) return false;
        return true;
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHash(this.value, this.targetType);
    }

    public String toString() {
        return "TypedStringValue: value [" + this.value + "], target type [" + String.valueOf(this.targetType) + "]";
    }
}

