/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.util.ObjectUtils;

public class GenericBeanDefinition
extends AbstractBeanDefinition {
    private @Nullable String parentName;

    public GenericBeanDefinition() {
    }

    public GenericBeanDefinition(BeanDefinition original) {
        super(original);
    }

    @Override
    public void setParentName(@Nullable String parentName) {
        this.parentName = parentName;
    }

    @Override
    public @Nullable String getParentName() {
        return this.parentName;
    }

    @Override
    public AbstractBeanDefinition cloneBeanDefinition() {
        return new GenericBeanDefinition(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof GenericBeanDefinition)) return false;
        GenericBeanDefinition that = (GenericBeanDefinition)other;
        if (!ObjectUtils.nullSafeEquals(this.parentName, that.parentName)) return false;
        if (!super.equals(other)) return false;
        return true;
    }

    @Override
    public String toString() {
        if (this.parentName != null) {
            return "Generic bean with parent '" + this.parentName + "': " + super.toString();
        }
        return "Generic bean: " + super.toString();
    }
}

