/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.function.Predicate;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;

public enum Nullness {
    UNSPECIFIED,
    NULLABLE,
    NON_NULL;

    private static final boolean KOTLIN_REFLECT_PRESENT;

    public static Nullness forMethodReturnType(Method method) {
        if (KOTLIN_REFLECT_PRESENT && KotlinDetector.isKotlinType(method.getDeclaringClass())) {
            return KotlinDelegate.forMethodReturnType(method);
        }
        return Nullness.hasNullableAnnotation(method) ? NULLABLE : Nullness.jSpecifyNullness(method, method.getDeclaringClass(), method.getAnnotatedReturnType());
    }

    public static Nullness forParameter(Parameter parameter) {
        if (KOTLIN_REFLECT_PRESENT && KotlinDetector.isKotlinType(parameter.getDeclaringExecutable().getDeclaringClass())) {
            MethodParameter methodParameter = MethodParameter.forParameter(parameter);
            return KotlinDelegate.forParameter(methodParameter.getExecutable(), methodParameter.getParameterIndex());
        }
        Executable executable = parameter.getDeclaringExecutable();
        return Nullness.hasNullableAnnotation(parameter) ? NULLABLE : Nullness.jSpecifyNullness(executable, executable.getDeclaringClass(), parameter.getAnnotatedType());
    }

    public static Nullness forMethodParameter(MethodParameter methodParameter) {
        return methodParameter.getParameterIndex() < 0 ? Nullness.forMethodReturnType(Objects.requireNonNull(methodParameter.getMethod())) : Nullness.forParameter(methodParameter.getParameter());
    }

    public static Nullness forField(Field field) {
        if (KOTLIN_REFLECT_PRESENT && KotlinDetector.isKotlinType(field.getDeclaringClass())) {
            return KotlinDelegate.forField(field);
        }
        return Nullness.hasNullableAnnotation(field) ? NULLABLE : Nullness.jSpecifyNullness(field, field.getDeclaringClass(), field.getAnnotatedType());
    }

    private static boolean hasNullableAnnotation(AnnotatedElement element) {
        for (Annotation annotation : element.getDeclaredAnnotations()) {
            if (!"Nullable".equals(annotation.annotationType().getSimpleName())) continue;
            return true;
        }
        return false;
    }

    private static Nullness jSpecifyNullness(AnnotatedElement annotatedElement, Class<?> declaringClass, AnnotatedType annotatedType) {
        Class clazz;
        Type type = annotatedType.getType();
        if (type instanceof Class && (clazz = (Class)type).isPrimitive()) {
            return clazz != Void.TYPE ? NON_NULL : UNSPECIFIED;
        }
        if (annotatedType.isAnnotationPresent(Nullable.class)) {
            return NULLABLE;
        }
        if (annotatedType.isAnnotationPresent(NonNull.class)) {
            return NON_NULL;
        }
        Nullness nullness = UNSPECIFIED;
        Package declaringPackage = declaringClass.getPackage();
        if (declaringPackage.isAnnotationPresent(NullMarked.class)) {
            nullness = NON_NULL;
        }
        if (declaringClass.isAnnotationPresent(NullMarked.class)) {
            nullness = NON_NULL;
        } else if (declaringClass.isAnnotationPresent(NullUnmarked.class)) {
            nullness = UNSPECIFIED;
        }
        if (annotatedElement.isAnnotationPresent(NullMarked.class)) {
            nullness = NON_NULL;
        } else if (annotatedElement.isAnnotationPresent(NullUnmarked.class)) {
            nullness = UNSPECIFIED;
        }
        return nullness;
    }

    static {
        KOTLIN_REFLECT_PRESENT = KotlinDetector.isKotlinReflectPresent();
    }

    private static class KotlinDelegate {
        private KotlinDelegate() {
        }

        public static Nullness forMethodReturnType(Method method) {
            KFunction function = ReflectJvmMapping.getKotlinFunction((Method)method);
            if (function == null) {
                String methodName = method.getName();
                if (methodName.startsWith("get")) {
                    String propertyName = KotlinDelegate.accessorToPropertyName(methodName);
                    KClass kClass = JvmClassMappingKt.getKotlinClass(method.getDeclaringClass());
                    for (KProperty property : KClasses.getMemberProperties((KClass)kClass)) {
                        if (!property.getName().equals(propertyName)) continue;
                        return property.getReturnType().isMarkedNullable() ? NULLABLE : NON_NULL;
                    }
                }
            } else {
                KType type = function.getReturnType();
                if (ReflectJvmMapping.getJavaType((KType)type) != Void.TYPE) {
                    return type.isMarkedNullable() ? NULLABLE : NON_NULL;
                }
            }
            return UNSPECIFIED;
        }

        public static Nullness forParameter(Executable executable, int parameterIndex) {
            block5: {
                Predicate<KParameter> predicate;
                KFunction function;
                block4: {
                    if (executable instanceof Method) {
                        Method method = (Method)executable;
                        function = ReflectJvmMapping.getKotlinFunction((Method)method);
                        predicate = p -> KParameter.Kind.VALUE.equals((Object)p.getKind());
                    } else {
                        function = ReflectJvmMapping.getKotlinFunction((Constructor)((Constructor)executable));
                        predicate = p -> KParameter.Kind.VALUE.equals((Object)p.getKind()) || KParameter.Kind.INSTANCE.equals((Object)p.getKind());
                    }
                    if (function != null) break block4;
                    String methodName = executable.getName();
                    if (!methodName.startsWith("set")) break block5;
                    String propertyName = KotlinDelegate.accessorToPropertyName(methodName);
                    KClass kClass = JvmClassMappingKt.getKotlinClass(executable.getDeclaringClass());
                    for (KProperty property : KClasses.getMemberProperties((KClass)kClass)) {
                        if (!property.getName().equals(propertyName)) continue;
                        return property.getReturnType().isMarkedNullable() ? NULLABLE : NON_NULL;
                    }
                    break block5;
                }
                int i2 = 0;
                for (KParameter kParameter : function.getParameters()) {
                    if (!predicate.test(kParameter) || parameterIndex != i2++) continue;
                    return kParameter.getType().isMarkedNullable() ? NULLABLE : NON_NULL;
                }
            }
            return UNSPECIFIED;
        }

        public static Nullness forField(Field field) {
            KProperty property = ReflectJvmMapping.getKotlinProperty((Field)field);
            if (property != null) {
                return property.getReturnType().isMarkedNullable() ? NULLABLE : NON_NULL;
            }
            return UNSPECIFIED;
        }

        private static String accessorToPropertyName(String method) {
            char[] methodNameChars = method.toCharArray();
            methodNameChars[3] = Character.toLowerCase(methodNameChars[3]);
            return new String(methodNameChars, 3, methodNameChars.length - 3);
        }
    }
}

