/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.Ordered;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationFilter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.AnnotationsProcessor;
import org.springframework.core.annotation.AttributeMethods;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

abstract class AnnotationsScanner {
    private static final @Nullable Annotation[] NO_ANNOTATIONS = new Annotation[0];
    private static final Method[] NO_METHODS = new Method[0];
    private static final Map<AnnotatedElement, Annotation[]> declaredAnnotationCache = new ConcurrentReferenceHashMap<AnnotatedElement, Annotation[]>(256);
    private static final Map<Class<?>, @Nullable Method[]> baseTypeMethodsCache = new ConcurrentReferenceHashMap(256);

    private AnnotationsScanner() {
    }

    static <C, R> @Nullable R scan(C context, AnnotatedElement source, MergedAnnotations.SearchStrategy searchStrategy, Predicate<Class<?>> searchEnclosingClass, AnnotationsProcessor<C, R> processor) {
        R result = AnnotationsScanner.process(context, source, searchStrategy, searchEnclosingClass, processor);
        return processor.finish(result);
    }

    private static <C, R> @Nullable R process(C context, AnnotatedElement source, MergedAnnotations.SearchStrategy searchStrategy, Predicate<Class<?>> searchEnclosingClass, AnnotationsProcessor<C, R> processor) {
        if (source instanceof Class) {
            Class clazz = (Class)source;
            return AnnotationsScanner.processClass(context, clazz, searchStrategy, searchEnclosingClass, processor);
        }
        if (source instanceof Method) {
            Method method = (Method)source;
            return AnnotationsScanner.processMethod(context, method, searchStrategy, processor);
        }
        return AnnotationsScanner.processElement(context, source, processor);
    }

    private static <C, R> @Nullable R processClass(C context, Class<?> source, MergedAnnotations.SearchStrategy searchStrategy, Predicate<Class<?>> searchEnclosingClass, AnnotationsProcessor<C, R> processor) {
        return switch (searchStrategy) {
            default -> throw new IncompatibleClassChangeError();
            case MergedAnnotations.SearchStrategy.DIRECT -> AnnotationsScanner.processElement(context, source, processor);
            case MergedAnnotations.SearchStrategy.INHERITED_ANNOTATIONS -> AnnotationsScanner.processClassInheritedAnnotations(context, source, processor);
            case MergedAnnotations.SearchStrategy.SUPERCLASS -> AnnotationsScanner.processClassHierarchy(context, source, processor, false, MergedAnnotations.Search.never);
            case MergedAnnotations.SearchStrategy.TYPE_HIERARCHY -> AnnotationsScanner.processClassHierarchy(context, source, processor, true, searchEnclosingClass);
        };
    }

    private static <C, R> @Nullable R processClassInheritedAnnotations(C context, Class<?> source, AnnotationsProcessor<C, R> processor) {
        try {
            if (AnnotationsScanner.isWithoutHierarchy(source, MergedAnnotations.Search.never)) {
                return AnnotationsScanner.processElement(context, source, processor);
            }
            @Nullable Annotation[] relevant = null;
            int remaining = Integer.MAX_VALUE;
            int aggregateIndex = 0;
            Class<?> root = source;
            while (source != null && source != Object.class && remaining > 0 && !AnnotationsScanner.hasPlainJavaAnnotationsOnly(source)) {
                R result = processor.doWithAggregate(context, aggregateIndex);
                if (result != null) {
                    return result;
                }
                @Nullable Annotation[] declaredAnns = AnnotationsScanner.getDeclaredAnnotations(source, true);
                if (declaredAnns.length > 0) {
                    if (relevant == null) {
                        relevant = root.getAnnotations();
                        remaining = relevant.length;
                    }
                    for (int i2 = 0; i2 < declaredAnns.length; ++i2) {
                        if (declaredAnns[i2] == null) continue;
                        boolean isRelevant = false;
                        for (int relevantIndex = 0; relevantIndex < relevant.length; ++relevantIndex) {
                            if (relevant[relevantIndex] == null || declaredAnns[i2].annotationType() != relevant[relevantIndex].annotationType()) continue;
                            isRelevant = true;
                            relevant[relevantIndex] = null;
                            --remaining;
                            break;
                        }
                        if (isRelevant) continue;
                        declaredAnns[i2] = null;
                    }
                }
                if ((result = processor.doWithAnnotations(context, aggregateIndex, source, declaredAnns)) != null) {
                    return result;
                }
                source = source.getSuperclass();
                ++aggregateIndex;
            }
        }
        catch (Throwable ex) {
            AnnotationUtils.handleIntrospectionFailure(source, ex);
        }
        return null;
    }

    private static <C, R> @Nullable R processClassHierarchy(C context, Class<?> source, AnnotationsProcessor<C, R> processor, boolean includeInterfaces, Predicate<Class<?>> searchEnclosingClass) {
        return AnnotationsScanner.processClassHierarchy(context, new int[]{0}, source, processor, includeInterfaces, searchEnclosingClass);
    }

    private static <C, R> @Nullable R processClassHierarchy(C context, int[] aggregateIndex, Class<?> source, AnnotationsProcessor<C, R> processor, boolean includeInterfaces, Predicate<Class<?>> searchEnclosingClass) {
        block11: {
            try {
                R superclassResult;
                Class<?> superclass;
                R result = processor.doWithAggregate(context, aggregateIndex[0]);
                if (result != null) {
                    return result;
                }
                if (AnnotationsScanner.hasPlainJavaAnnotationsOnly(source)) {
                    return null;
                }
                @Nullable Annotation[] annotations = AnnotationsScanner.getDeclaredAnnotations(source, false);
                result = processor.doWithAnnotations(context, aggregateIndex[0], source, annotations);
                if (result != null) {
                    return result;
                }
                aggregateIndex[0] = aggregateIndex[0] + 1;
                if (includeInterfaces) {
                    for (Class<?> interfaceType : source.getInterfaces()) {
                        R interfacesResult = AnnotationsScanner.processClassHierarchy(context, aggregateIndex, interfaceType, processor, true, searchEnclosingClass);
                        if (interfacesResult == null) continue;
                        return interfacesResult;
                    }
                }
                if ((superclass = source.getSuperclass()) != Object.class && superclass != null && (superclassResult = AnnotationsScanner.processClassHierarchy(context, aggregateIndex, superclass, processor, includeInterfaces, searchEnclosingClass)) != null) {
                    return superclassResult;
                }
                if (!searchEnclosingClass.test(source)) break block11;
                try {
                    R enclosingResult;
                    Class<?> enclosingClass = source.getEnclosingClass();
                    if (enclosingClass != null && (enclosingResult = AnnotationsScanner.processClassHierarchy(context, aggregateIndex, enclosingClass, processor, includeInterfaces, searchEnclosingClass)) != null) {
                        return enclosingResult;
                    }
                }
                catch (Throwable ex) {
                    AnnotationUtils.handleIntrospectionFailure(source, ex);
                }
            }
            catch (Throwable ex) {
                AnnotationUtils.handleIntrospectionFailure(source, ex);
            }
        }
        return null;
    }

    private static <C, R> @Nullable R processMethod(C context, Method source, MergedAnnotations.SearchStrategy searchStrategy, AnnotationsProcessor<C, R> processor) {
        return switch (searchStrategy) {
            default -> throw new IncompatibleClassChangeError();
            case MergedAnnotations.SearchStrategy.DIRECT, MergedAnnotations.SearchStrategy.INHERITED_ANNOTATIONS -> AnnotationsScanner.processMethodInheritedAnnotations(context, source, processor);
            case MergedAnnotations.SearchStrategy.SUPERCLASS -> AnnotationsScanner.processMethodHierarchy(context, new int[]{0}, source.getDeclaringClass(), processor, source, false);
            case MergedAnnotations.SearchStrategy.TYPE_HIERARCHY -> AnnotationsScanner.processMethodHierarchy(context, new int[]{0}, source.getDeclaringClass(), processor, source, true);
        };
    }

    private static <C, R> @Nullable R processMethodInheritedAnnotations(C context, Method source, AnnotationsProcessor<C, R> processor) {
        try {
            R result = processor.doWithAggregate(context, 0);
            return result != null ? result : AnnotationsScanner.processMethodAnnotations(context, 0, source, processor);
        }
        catch (Throwable ex) {
            AnnotationUtils.handleIntrospectionFailure(source, ex);
            return null;
        }
    }

    private static <C, R> @Nullable R processMethodHierarchy(C context, int[] aggregateIndex, Class<?> sourceClass, AnnotationsProcessor<C, R> processor, Method rootMethod, boolean includeInterfaces) {
        try {
            R superclassResult;
            Class<?> superclass;
            R result = processor.doWithAggregate(context, aggregateIndex[0]);
            if (result != null) {
                return result;
            }
            if (AnnotationsScanner.hasPlainJavaAnnotationsOnly(sourceClass)) {
                return null;
            }
            boolean calledProcessor = false;
            if (sourceClass == rootMethod.getDeclaringClass()) {
                result = AnnotationsScanner.processMethodAnnotations(context, aggregateIndex[0], rootMethod, processor);
                calledProcessor = true;
                if (result != null) {
                    return result;
                }
            } else {
                for (Method method : AnnotationsScanner.getBaseTypeMethods(context, sourceClass)) {
                    if (method == null || !AnnotationsScanner.isOverride(rootMethod, method)) continue;
                    result = AnnotationsScanner.processMethodAnnotations(context, aggregateIndex[0], method, processor);
                    calledProcessor = true;
                    if (result == null) continue;
                    return result;
                }
            }
            if (Modifier.isPrivate(rootMethod.getModifiers())) {
                return null;
            }
            if (calledProcessor) {
                aggregateIndex[0] = aggregateIndex[0] + 1;
            }
            if (includeInterfaces) {
                for (GenericDeclaration genericDeclaration : sourceClass.getInterfaces()) {
                    R interfacesResult = AnnotationsScanner.processMethodHierarchy(context, aggregateIndex, genericDeclaration, processor, rootMethod, true);
                    if (interfacesResult == null) continue;
                    return interfacesResult;
                }
            }
            if ((superclass = sourceClass.getSuperclass()) != Object.class && superclass != null && (superclassResult = AnnotationsScanner.processMethodHierarchy(context, aggregateIndex, superclass, processor, rootMethod, includeInterfaces)) != null) {
                return superclassResult;
            }
        }
        catch (Throwable ex) {
            AnnotationUtils.handleIntrospectionFailure(rootMethod, ex);
        }
        return null;
    }

    private static <C> @Nullable Method[] getBaseTypeMethods(C context, Class<?> baseType) {
        if (baseType == Object.class || AnnotationsScanner.hasPlainJavaAnnotationsOnly(baseType)) {
            return NO_METHODS;
        }
        @Nullable Method[] methods = baseTypeMethodsCache.get(baseType);
        if (methods == null) {
            methods = ReflectionUtils.getDeclaredMethods(baseType);
            int cleared = 0;
            for (int i2 = 0; i2 < methods.length; ++i2) {
                if (!Modifier.isPrivate(methods[i2].getModifiers()) && !AnnotationsScanner.hasPlainJavaAnnotationsOnly(methods[i2]) && AnnotationsScanner.getDeclaredAnnotations(methods[i2], false).length != 0) continue;
                methods[i2] = null;
                ++cleared;
            }
            if (cleared == methods.length) {
                methods = NO_METHODS;
            }
            baseTypeMethodsCache.put(baseType, methods);
        }
        return methods;
    }

    private static boolean isOverride(Method rootMethod, Method candidateMethod) {
        return !Modifier.isPrivate(candidateMethod.getModifiers()) && candidateMethod.getParameterCount() == rootMethod.getParameterCount() && candidateMethod.getName().equals(rootMethod.getName()) && AnnotationsScanner.hasSameParameterTypes(rootMethod, candidateMethod);
    }

    private static boolean hasSameParameterTypes(Method rootMethod, Method candidateMethod) {
        Object[] rootParameterTypes = rootMethod.getParameterTypes();
        Object[] candidateParameterTypes = candidateMethod.getParameterTypes();
        if (Arrays.equals(candidateParameterTypes, rootParameterTypes)) {
            return true;
        }
        return AnnotationsScanner.hasSameGenericTypeParameters(rootMethod, candidateMethod, rootParameterTypes);
    }

    private static boolean hasSameGenericTypeParameters(Method rootMethod, Method candidateMethod, Class<?>[] rootParameterTypes) {
        Class<?> rootDeclaringClass = rootMethod.getDeclaringClass();
        Class<?> candidateDeclaringClass = candidateMethod.getDeclaringClass();
        if (!candidateDeclaringClass.isAssignableFrom(rootDeclaringClass)) {
            return false;
        }
        for (int i2 = 0; i2 < rootParameterTypes.length; ++i2) {
            Class<?> resolvedParameterType = ResolvableType.forMethodParameter(candidateMethod, i2, rootDeclaringClass).toClass();
            if (rootParameterTypes[i2] == resolvedParameterType) continue;
            return false;
        }
        return true;
    }

    private static <C, R> @Nullable R processMethodAnnotations(C context, int aggregateIndex, Method source, AnnotationsProcessor<C, R> processor) {
        @Nullable Object[] annotations = AnnotationsScanner.getDeclaredAnnotations(source, false);
        R result = processor.doWithAnnotations(context, aggregateIndex, source, (Annotation[])annotations);
        if (result != null) {
            return result;
        }
        Method bridgedMethod = BridgeMethodResolver.findBridgedMethod(source);
        if (bridgedMethod != source) {
            @Nullable Annotation[] bridgedAnnotations = AnnotationsScanner.getDeclaredAnnotations(bridgedMethod, true);
            for (int i2 = 0; i2 < bridgedAnnotations.length; ++i2) {
                if (!ObjectUtils.containsElement(annotations, bridgedAnnotations[i2])) continue;
                bridgedAnnotations[i2] = null;
            }
            return processor.doWithAnnotations(context, aggregateIndex, source, bridgedAnnotations);
        }
        return null;
    }

    private static <C, R> @Nullable R processElement(C context, AnnotatedElement source, AnnotationsProcessor<C, R> processor) {
        try {
            R result = processor.doWithAggregate(context, 0);
            return result != null ? result : processor.doWithAnnotations(context, 0, source, AnnotationsScanner.getDeclaredAnnotations(source, false));
        }
        catch (Throwable ex) {
            AnnotationUtils.handleIntrospectionFailure(source, ex);
            return null;
        }
    }

    static <A extends Annotation> @Nullable A getDeclaredAnnotation(AnnotatedElement source, Class<A> annotationType) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = AnnotationsScanner.getDeclaredAnnotations(source, false)) {
            if (annotation == null || annotationType != annotation.annotationType()) continue;
            return (A)annotation;
        }
        return null;
    }

    static @Nullable Annotation[] getDeclaredAnnotations(AnnotatedElement source, boolean defensive) {
        boolean cached = false;
        @Nullable Annotation[] annotations = declaredAnnotationCache.get(source);
        if (annotations != null) {
            cached = true;
        } else {
            annotations = source.getDeclaredAnnotations();
            if (annotations.length != 0) {
                boolean allIgnored = true;
                for (int i2 = 0; i2 < annotations.length; ++i2) {
                    Annotation annotation = annotations[i2];
                    if (AnnotationsScanner.isIgnorable(annotation.annotationType()) || !AttributeMethods.forAnnotationType(annotation.annotationType()).canLoad(annotation, source)) {
                        annotations[i2] = null;
                        continue;
                    }
                    allIgnored = false;
                }
                Annotation[] annotationArray = annotations = allIgnored ? NO_ANNOTATIONS : annotations;
                if (source instanceof Class || source instanceof Member) {
                    declaredAnnotationCache.put(source, annotations);
                    cached = true;
                }
            }
        }
        if (!defensive || annotations.length == 0 || !cached) {
            return annotations;
        }
        return (Annotation[])annotations.clone();
    }

    private static boolean isIgnorable(Class<?> annotationType) {
        return AnnotationFilter.PLAIN.matches(annotationType);
    }

    static boolean isKnownEmpty(AnnotatedElement source, MergedAnnotations.SearchStrategy searchStrategy, Predicate<Class<?>> searchEnclosingClass) {
        if (AnnotationsScanner.hasPlainJavaAnnotationsOnly(source)) {
            return true;
        }
        if (searchStrategy == MergedAnnotations.SearchStrategy.DIRECT || AnnotationsScanner.isWithoutHierarchy(source, searchEnclosingClass)) {
            Method method;
            if (source instanceof Method && (method = (Method)source).isBridge()) {
                return false;
            }
            return AnnotationsScanner.getDeclaredAnnotations(source, false).length == 0;
        }
        return false;
    }

    static boolean hasPlainJavaAnnotationsOnly(@Nullable Object annotatedElement) {
        if (annotatedElement instanceof Class) {
            Class clazz = (Class)annotatedElement;
            return AnnotationsScanner.hasPlainJavaAnnotationsOnly(clazz);
        }
        if (annotatedElement instanceof Member) {
            Member member = (Member)annotatedElement;
            return AnnotationsScanner.hasPlainJavaAnnotationsOnly(member.getDeclaringClass());
        }
        return false;
    }

    static boolean hasPlainJavaAnnotationsOnly(Class<?> type) {
        return type.getName().startsWith("java.") || type == Ordered.class;
    }

    private static boolean isWithoutHierarchy(AnnotatedElement source, Predicate<Class<?>> searchEnclosingClass) {
        if (source == Object.class) {
            return true;
        }
        if (source instanceof Class) {
            boolean noSuperTypes;
            Class sourceClass = (Class)source;
            boolean bl = noSuperTypes = sourceClass.getSuperclass() == Object.class && sourceClass.getInterfaces().length == 0;
            return searchEnclosingClass.test(sourceClass) ? noSuperTypes && sourceClass.getEnclosingClass() == null : noSuperTypes;
        }
        if (source instanceof Method) {
            Method sourceMethod = (Method)source;
            return Modifier.isPrivate(sourceMethod.getModifiers()) || AnnotationsScanner.isWithoutHierarchy(sourceMethod.getDeclaringClass(), searchEnclosingClass);
        }
        return true;
    }

    static void clearCache() {
        declaredAnnotationCache.clear();
        baseTypeMethodsCache.clear();
    }
}

