/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import org.jspecify.annotations.Nullable;
import org.springframework.core.env.AbstractPropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;

public class PropertySourcesPropertyResolver
extends AbstractPropertyResolver {
    private final @Nullable PropertySources propertySources;

    public PropertySourcesPropertyResolver(@Nullable PropertySources propertySources) {
        this.propertySources = propertySources;
    }

    @Override
    public boolean containsProperty(String key) {
        if (this.propertySources != null) {
            for (PropertySource propertySource : this.propertySources) {
                if (!propertySource.containsProperty(key)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public @Nullable String getProperty(String key) {
        return this.getProperty(key, String.class, true);
    }

    @Override
    public <T> @Nullable T getProperty(String key, Class<T> targetValueType) {
        return this.getProperty(key, targetValueType, true);
    }

    @Override
    protected @Nullable String getPropertyAsRawString(String key) {
        return this.getProperty(key, String.class, false);
    }

    protected <T> @Nullable T getProperty(String key, Class<T> targetValueType, boolean resolveNestedPlaceholders) {
        if (this.propertySources != null) {
            for (PropertySource propertySource : this.propertySources) {
                Object value;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Searching for key '" + key + "' in PropertySource '" + propertySource.getName() + "'");
                }
                if ((value = propertySource.getProperty(key)) == null) continue;
                if (resolveNestedPlaceholders) {
                    if (value instanceof String) {
                        String string = (String)value;
                        value = this.resolveNestedPlaceholders(string);
                    } else if (value instanceof CharSequence) {
                        CharSequence cs = (CharSequence)value;
                        if (String.class.equals(targetValueType) || CharSequence.class.equals(targetValueType)) {
                            value = this.resolveNestedPlaceholders(cs.toString());
                        }
                    }
                }
                this.logKeyFound(key, propertySource, value);
                return this.convertValueIfNecessary(value, targetValueType);
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Could not find key '" + key + "' in any property source");
        }
        return null;
    }

    protected void logKeyFound(String key, PropertySource<?> propertySource, Object value) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Found key '" + key + "' in PropertySource '" + propertySource.getName() + "' with value of type " + value.getClass().getSimpleName());
        }
    }
}

