/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.lang.classfile.AccessFlags;
import java.lang.classfile.ClassElement;
import java.lang.classfile.ClassModel;
import java.lang.classfile.Interfaces;
import java.lang.classfile.MethodModel;
import java.lang.classfile.Superclass;
import java.lang.classfile.attribute.InnerClassesAttribute;
import java.lang.classfile.attribute.NestHostAttribute;
import java.lang.classfile.attribute.RuntimeVisibleAnnotationsAttribute;
import java.lang.reflect.AccessFlag;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.classreading.ClassFileAnnotationMetadata;
import org.springframework.core.type.classreading.ClassFileClassMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class ClassFileClassMetadata
implements AnnotationMetadata {
    private final String className;
    private final AccessFlags accessFlags;
    private final @Nullable String enclosingClassName;
    private final @Nullable String superClassName;
    private final boolean independentInnerClass;
    private final Set<String> interfaceNames;
    private final Set<String> memberClassNames;
    private final Set<MethodMetadata> declaredMethods;
    private final MergedAnnotations mergedAnnotations;
    private @Nullable Set<String> annotationTypes;

    ClassFileClassMetadata(String className, AccessFlags accessFlags, @Nullable String enclosingClassName, @Nullable String superClassName, boolean independentInnerClass, Set<String> interfaceNames, Set<String> memberClassNames, Set<MethodMetadata> declaredMethods, MergedAnnotations mergedAnnotations) {
        this.className = className;
        this.accessFlags = accessFlags;
        this.enclosingClassName = enclosingClassName;
        this.superClassName = !className.endsWith(".package-info") ? superClassName : null;
        this.independentInnerClass = independentInnerClass;
        this.interfaceNames = interfaceNames;
        this.memberClassNames = memberClassNames;
        this.declaredMethods = declaredMethods;
        this.mergedAnnotations = mergedAnnotations;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public boolean isInterface() {
        return this.accessFlags.has(AccessFlag.INTERFACE);
    }

    @Override
    public boolean isAnnotation() {
        return this.accessFlags.has(AccessFlag.ANNOTATION);
    }

    @Override
    public boolean isAbstract() {
        return this.accessFlags.has(AccessFlag.ABSTRACT);
    }

    @Override
    public boolean isFinal() {
        return this.accessFlags.has(AccessFlag.FINAL);
    }

    @Override
    public boolean isIndependent() {
        return this.enclosingClassName == null || this.independentInnerClass;
    }

    @Override
    public @Nullable String getEnclosingClassName() {
        return this.enclosingClassName;
    }

    @Override
    public @Nullable String getSuperClassName() {
        return this.superClassName;
    }

    @Override
    public String[] getInterfaceNames() {
        return StringUtils.toStringArray(this.interfaceNames);
    }

    @Override
    public String[] getMemberClassNames() {
        return StringUtils.toStringArray(this.memberClassNames);
    }

    @Override
    public MergedAnnotations getAnnotations() {
        return this.mergedAnnotations;
    }

    @Override
    public Set<String> getAnnotationTypes() {
        Set<String> annotationTypes = this.annotationTypes;
        if (annotationTypes == null) {
            this.annotationTypes = annotationTypes = Collections.unmodifiableSet(AnnotationMetadata.super.getAnnotationTypes());
        }
        return annotationTypes;
    }

    @Override
    public Set<MethodMetadata> getAnnotatedMethods(String annotationName) {
        LinkedHashSet<MethodMetadata> result = new LinkedHashSet<MethodMetadata>(4);
        for (MethodMetadata annotatedMethod : this.declaredMethods) {
            if (!annotatedMethod.isAnnotated(annotationName)) continue;
            result.add(annotatedMethod);
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Set<MethodMetadata> getDeclaredMethods() {
        return Collections.unmodifiableSet(this.declaredMethods);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof ClassFileClassMetadata)) return false;
        ClassFileClassMetadata that = (ClassFileClassMetadata)other;
        if (!this.className.equals(that.className)) return false;
        return true;
    }

    public int hashCode() {
        return this.className.hashCode();
    }

    public String toString() {
        return this.className;
    }

    static ClassFileClassMetadata of(ClassModel classModel, @Nullable ClassLoader classLoader) {
        Builder builder = new Builder(classLoader);
        builder.classEntry(classModel.thisClass());
        String currentClassName = classModel.thisClass().name().stringValue();
        classModel.elementStream().forEach(classElement -> {
            ClassElement classElement2 = classElement;
            Objects.requireNonNull(classElement2);
            ClassElement selector0$temp = classElement2;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AccessFlags.class, NestHostAttribute.class, InnerClassesAttribute.class, RuntimeVisibleAnnotationsAttribute.class, Superclass.class, Interfaces.class, MethodModel.class}, (ClassElement)selector0$temp, index$1)) {
                case 0: {
                    AccessFlags flags = (AccessFlags)selector0$temp;
                    builder.accessFlags(flags);
                    break;
                }
                case 1: {
                    builder.enclosingClass(classModel.thisClass());
                    break;
                }
                case 2: {
                    InnerClassesAttribute innerClasses = (InnerClassesAttribute)selector0$temp;
                    builder.nestMembers(currentClassName, innerClasses);
                    break;
                }
                case 3: {
                    RuntimeVisibleAnnotationsAttribute annotationsAttribute = (RuntimeVisibleAnnotationsAttribute)selector0$temp;
                    builder.mergedAnnotations(ClassFileAnnotationMetadata.createMergedAnnotations((String)ClassUtils.convertResourcePathToClassName(currentClassName), (RuntimeVisibleAnnotationsAttribute)annotationsAttribute, (ClassLoader)classLoader));
                    break;
                }
                case 4: {
                    Superclass superclass = (Superclass)selector0$temp;
                    builder.superClass(superclass);
                    break;
                }
                case 5: {
                    Interfaces interfaces = (Interfaces)selector0$temp;
                    builder.interfaces(interfaces);
                    break;
                }
                case 6: {
                    MethodModel method = (MethodModel)selector0$temp;
                    builder.method(method);
                    break;
                }
            }
        });
        return builder.build();
    }
}

