/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.lang.classfile.AccessFlags;
import java.lang.classfile.MethodModel;
import java.lang.classfile.attribute.RuntimeVisibleAnnotationsAttribute;
import java.lang.constant.ClassDesc;
import java.lang.reflect.AccessFlag;
import java.util.Collections;
import org.jspecify.annotations.Nullable;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.classreading.ClassFileAnnotationMetadata;
import org.springframework.core.type.classreading.ClassFileMethodMetadata;
import org.springframework.util.ClassUtils;

class ClassFileMethodMetadata
implements MethodMetadata {
    private final String methodName;
    private final AccessFlags accessFlags;
    private final @Nullable String declaringClassName;
    private final String returnTypeName;
    private final Object source;
    private final MergedAnnotations annotations;

    ClassFileMethodMetadata(String methodName, AccessFlags accessFlags, @Nullable String declaringClassName, String returnTypeName, Object source, MergedAnnotations annotations) {
        this.methodName = methodName;
        this.accessFlags = accessFlags;
        this.declaringClassName = declaringClassName;
        this.returnTypeName = returnTypeName;
        this.source = source;
        this.annotations = annotations;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public @Nullable String getDeclaringClassName() {
        return this.declaringClassName;
    }

    @Override
    public String getReturnTypeName() {
        return this.returnTypeName;
    }

    @Override
    public boolean isAbstract() {
        return this.accessFlags.has(AccessFlag.ABSTRACT);
    }

    @Override
    public boolean isStatic() {
        return this.accessFlags.has(AccessFlag.STATIC);
    }

    @Override
    public boolean isFinal() {
        return this.accessFlags.has(AccessFlag.FINAL);
    }

    @Override
    public boolean isOverridable() {
        return !this.isStatic() && !this.isFinal() && !this.isPrivate();
    }

    private boolean isPrivate() {
        return this.accessFlags.has(AccessFlag.PRIVATE);
    }

    public boolean isSynthetic() {
        return this.accessFlags.has(AccessFlag.SYNTHETIC);
    }

    public boolean isDefaultConstructor() {
        return this.methodName.equals("<init>");
    }

    @Override
    public MergedAnnotations getAnnotations() {
        return this.annotations;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof ClassFileMethodMetadata)) return false;
        ClassFileMethodMetadata that = (ClassFileMethodMetadata)other;
        if (!this.source.equals(that.source)) return false;
        return true;
    }

    public int hashCode() {
        return this.source.hashCode();
    }

    public String toString() {
        return this.source.toString();
    }

    static ClassFileMethodMetadata of(MethodModel methodModel, ClassLoader classLoader) {
        String methodName = methodModel.methodName().stringValue();
        AccessFlags flags = methodModel.flags();
        String declaringClassName = methodModel.parent().map(parent -> ClassUtils.convertResourcePathToClassName(parent.thisClass().name().stringValue())).orElse(null);
        ClassDesc returnType = methodModel.methodTypeSymbol().returnType();
        String returnTypeName = returnType.packageName() + "." + returnType.displayName();
        Source source = new Source(declaringClassName, flags, methodName, methodModel.methodTypeSymbol());
        MergedAnnotations annotations = methodModel.elementStream().filter(element -> element instanceof RuntimeVisibleAnnotationsAttribute).findFirst().map(element -> ClassFileAnnotationMetadata.createMergedAnnotations((String)methodName, (RuntimeVisibleAnnotationsAttribute)((RuntimeVisibleAnnotationsAttribute)element), (ClassLoader)classLoader)).orElse(MergedAnnotations.of(Collections.emptyList()));
        return new ClassFileMethodMetadata(methodName, flags, declaringClassName, returnTypeName, (Object)source, annotations);
    }
}

