/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.Assert;

@FunctionalInterface
public interface ClientHttpRequestInterceptor {
    public ClientHttpResponse intercept(HttpRequest var1, byte[] var2, ClientHttpRequestExecution var3) throws IOException;

    default public ClientHttpRequestInterceptor andThen(ClientHttpRequestInterceptor interceptor) {
        Assert.notNull((Object)interceptor, "ClientHttpRequestInterceptor must not be null");
        return (request, body2, execution) -> {
            ClientHttpRequestExecution nextExecution = (nextRequest, nextBody) -> interceptor.intercept(nextRequest, nextBody, execution);
            return this.intercept(request, body2, nextExecution);
        };
    }

    default public ClientHttpRequestExecution apply(ClientHttpRequestExecution execution) {
        Assert.notNull((Object)execution, "ClientHttpRequestExecution must not be null");
        return (request, body2) -> this.intercept(request, body2, execution);
    }
}

