/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StreamUtils;

class JdkClientHttpResponse
implements ClientHttpResponse {
    private final HttpResponse<InputStream> response;
    private final HttpHeaders headers;
    private final InputStream body;

    JdkClientHttpResponse(HttpResponse<InputStream> response, Consumer<HttpHeaders> headersConsumer, @Nullable InputStream body2) {
        this.response = response;
        this.headers = JdkClientHttpResponse.adaptHeaders(response, headersConsumer);
        this.body = body2 != null ? body2 : InputStream.nullInputStream();
    }

    private static HttpHeaders adaptHeaders(HttpResponse<?> response, Consumer<HttpHeaders> headersConsumer) {
        Map<String, List<String>> rawHeaders = response.headers().map();
        HttpHeaders headers = new HttpHeaders();
        rawHeaders.forEach(headers::put);
        headersConsumer.accept(headers);
        return HttpHeaders.readOnlyHttpHeaders(headers);
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return HttpStatusCode.valueOf(this.response.statusCode());
    }

    @Override
    public String getStatusText() {
        HttpStatusCode httpStatusCode = this.getStatusCode();
        if (httpStatusCode instanceof HttpStatus) {
            HttpStatus status = (HttpStatus)httpStatusCode;
            return status.getReasonPhrase();
        }
        return "";
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public InputStream getBody() throws IOException {
        return this.body;
    }

    @Override
    public void close() {
        try {
            try {
                StreamUtils.drain(this.body);
            }
            finally {
                this.body.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

