/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.reactive;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.util.Assert;

public class JdkHttpClientResourceFactory
implements InitializingBean,
DisposableBean {
    private @Nullable Executor executor;
    private String threadPrefix = "jdk-http";

    public void setExecutor(@Nullable Executor executor) {
        this.executor = executor;
    }

    public @Nullable Executor getExecutor() {
        return this.executor;
    }

    public void setThreadPrefix(String threadPrefix) {
        Assert.notNull((Object)threadPrefix, "Thread prefix is required");
        this.threadPrefix = threadPrefix;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.executor == null) {
            String name = this.threadPrefix + "@" + Integer.toHexString(this.hashCode());
            this.executor = Executors.newCachedThreadPool((ThreadFactory)new CustomizableThreadFactory(name));
        }
    }

    @Override
    public void destroy() throws Exception {
        Executor executor = this.executor;
        if (executor instanceof ExecutorService) {
            ExecutorService executorService = (ExecutorService)executor;
            executorService.shutdown();
        }
    }
}

