/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.CodecException;
import org.springframework.core.codec.EncodingException;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.log.LogFormatUtils;
import org.springframework.http.MediaType;
import org.springframework.http.codec.HttpMessageEncoder;
import org.springframework.http.codec.JacksonCodecSupport;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.http.converter.json.MappingJacksonValue;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonEncoding;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.exc.JacksonIOException;
import tools.jackson.core.util.ByteArrayBuilder;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.ObjectWriter;
import tools.jackson.databind.SequenceWriter;
import tools.jackson.databind.cfg.MapperBuilder;
import tools.jackson.databind.exc.InvalidDefinitionException;
import tools.jackson.databind.ser.FilterProvider;

public abstract class AbstractJacksonEncoder<T extends ObjectMapper>
extends JacksonCodecSupport<T>
implements HttpMessageEncoder<Object> {
    private static final byte[] NEWLINE_SEPARATOR = new byte[]{10};
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final Map<String, JsonEncoding> ENCODINGS = CollectionUtils.newHashMap(JsonEncoding.values().length);
    private final List<MediaType> streamingMediaTypes = new ArrayList<MediaType>(1);

    protected AbstractJacksonEncoder(MapperBuilder<T, ?> builder, MimeType ... mimeTypes) {
        super(builder, mimeTypes);
    }

    protected AbstractJacksonEncoder(T mapper, MimeType ... mimeTypes) {
        super(mapper, mimeTypes);
    }

    public void setStreamingMediaTypes(List<MediaType> mediaTypes) {
        this.streamingMediaTypes.clear();
        this.streamingMediaTypes.addAll(mediaTypes);
    }

    @Override
    public boolean canEncode(ResolvableType elementType, @Nullable MimeType mimeType) {
        Charset charset;
        if (!this.supportsMimeType(mimeType)) {
            return false;
        }
        if (mimeType != null && mimeType.getCharset() != null && !ENCODINGS.containsKey((charset = mimeType.getCharset()).name())) {
            return false;
        }
        if (this.mapperRegistrations != null && this.selectMapper(elementType, mimeType) == null) {
            return false;
        }
        Class<?> elementClass = elementType.toClass();
        if (MappingJacksonValue.class.isAssignableFrom(elementClass)) {
            throw new UnsupportedOperationException("MappingJacksonValue is not supported, use hints instead");
        }
        return !ServerSentEvent.class.isAssignableFrom(elementClass);
    }

    @Override
    public Flux<DataBuffer> encode(Publisher<?> inputStream, DataBufferFactory bufferFactory, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        Assert.notNull(inputStream, "'inputStream' must not be null");
        Assert.notNull((Object)bufferFactory, "'bufferFactory' must not be null");
        Assert.notNull((Object)elementType, "'elementType' must not be null");
        return Flux.deferContextual(contextView -> {
            Map<String, Object> hintsToUse;
            Map<String, Object> map = hintsToUse = contextView.isEmpty() ? hints : Hints.merge(hints, ContextView.class.getName(), contextView);
            if (inputStream instanceof Mono) {
                return Mono.from((Publisher)inputStream).map(value -> this.encodeValue(value, bufferFactory, elementType, mimeType, hintsToUse)).flux();
            }
            try {
                Flux dataBufferFlux;
                Object mapper = this.selectMapper(elementType, mimeType);
                if (mapper == null) {
                    throw new IllegalStateException("No ObjectMapper for " + String.valueOf(elementType));
                }
                ObjectWriter writer = this.createObjectWriter(mapper, elementType, mimeType, hintsToUse);
                ByteArrayBuilder byteBuilder = new ByteArrayBuilder(writer.generatorFactory()._getBufferRecycler());
                JsonEncoding encoding = this.getJsonEncoding(mimeType);
                JsonGenerator generator = mapper.createGenerator((OutputStream)byteBuilder, encoding);
                SequenceWriter sequenceWriter = writer.writeValues(generator);
                byte[] separator = this.getStreamingMediaTypeSeparator(mimeType);
                if (separator != null) {
                    dataBufferFlux = Flux.from((Publisher)inputStream).map(value -> this.encodeStreamingValue(value, bufferFactory, hintsToUse, sequenceWriter, byteBuilder, EMPTY_BYTES, separator));
                } else {
                    JsonArrayJoinHelper helper = new JsonArrayJoinHelper();
                    dataBufferFlux = Flux.from((Publisher)inputStream).map(value -> {
                        byte[] prefix = helper.getPrefix();
                        byte[] delimiter = helper.getDelimiter();
                        DataBuffer dataBuffer = this.encodeStreamingValue(value, bufferFactory, hintsToUse, sequenceWriter, byteBuilder, delimiter, EMPTY_BYTES);
                        return prefix.length > 0 ? bufferFactory.join(List.of(bufferFactory.wrap(prefix), dataBuffer)) : dataBuffer;
                    }).switchIfEmpty((Publisher)Mono.fromCallable(() -> bufferFactory.wrap(helper.getPrefix()))).concatWith((Publisher)Mono.fromCallable(() -> bufferFactory.wrap(helper.getSuffix())));
                }
                return dataBufferFlux.doOnNext(dataBuffer -> Hints.touchDataBuffer(dataBuffer, hintsToUse, this.logger)).doAfterTerminate(() -> {
                    try {
                        generator.close();
                        byteBuilder.release();
                    }
                    catch (JacksonIOException ex) {
                        this.logger.error("Could not close Encoder resources", ex);
                    }
                });
            }
            catch (JacksonIOException ex) {
                return Flux.error((Throwable)ex);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataBuffer encodeValue(Object value, DataBufferFactory bufferFactory, ResolvableType valueType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        Object mapper = this.selectMapper(valueType, mimeType);
        if (mapper == null) {
            throw new IllegalStateException("No ObjectMapper for " + String.valueOf(valueType));
        }
        ObjectWriter writer = this.createObjectWriter(mapper, valueType, mimeType, hints);
        ByteArrayBuilder byteBuilder = new ByteArrayBuilder(writer.generatorFactory()._getBufferRecycler());
        try {
            JsonEncoding encoding = this.getJsonEncoding(mimeType);
            this.logValue(hints, value);
            try (JsonGenerator generator = writer.createGenerator((OutputStream)byteBuilder, encoding);){
                writer.writeValue(generator, value);
                generator.flush();
            }
            catch (InvalidDefinitionException ex) {
                throw new CodecException("Type definition error: " + String.valueOf(ex.getType()), ex);
            }
            catch (JacksonException ex) {
                throw new EncodingException("JSON encoding error: " + ex.getOriginalMessage(), ex);
            }
            byte[] bytes = byteBuilder.toByteArray();
            DataBuffer buffer = bufferFactory.allocateBuffer(bytes.length);
            buffer.write(bytes);
            Hints.touchDataBuffer(buffer, hints, this.logger);
            DataBuffer dataBuffer = buffer;
            return dataBuffer;
        }
        finally {
            byteBuilder.release();
        }
    }

    private DataBuffer encodeStreamingValue(Object value, DataBufferFactory bufferFactory, @Nullable Map<String, Object> hints, SequenceWriter sequenceWriter, ByteArrayBuilder byteArrayBuilder, byte[] prefix, byte[] suffix) {
        int length;
        int offset;
        this.logValue(hints, value);
        try {
            sequenceWriter.write(value);
            sequenceWriter.flush();
        }
        catch (InvalidDefinitionException ex) {
            throw new CodecException("Type definition error: " + String.valueOf(ex.getType()), ex);
        }
        catch (JacksonException ex) {
            throw new EncodingException("JSON encoding error: " + ex.getOriginalMessage(), ex);
        }
        byte[] bytes = byteArrayBuilder.toByteArray();
        byteArrayBuilder.reset();
        if (bytes.length > 0 && bytes[0] == 32) {
            offset = 1;
            length = bytes.length - 1;
        } else {
            offset = 0;
            length = bytes.length;
        }
        DataBuffer buffer = bufferFactory.allocateBuffer(length + prefix.length + suffix.length);
        if (prefix.length != 0) {
            buffer.write(prefix);
        }
        buffer.write(bytes, offset, length);
        if (suffix.length != 0) {
            buffer.write(suffix);
        }
        Hints.touchDataBuffer(buffer, hints, this.logger);
        return buffer;
    }

    private void logValue(@Nullable Map<String, Object> hints, Object value) {
        if (!Hints.isLoggingSuppressed(hints)) {
            LogFormatUtils.traceDebug(this.logger, traceOn -> {
                String formatted = LogFormatUtils.formatValue(value, traceOn == false);
                return Hints.getLogPrefix(hints) + "Encoding [" + formatted + "]";
            });
        }
    }

    private ObjectWriter createObjectWriter(T mapper, ResolvableType valueType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        ObjectWriter writer;
        JavaType javaType = this.getJavaType(valueType.getType(), null);
        Class jsonView = null;
        FilterProvider filters = null;
        if (hints != null) {
            jsonView = (Class)hints.get(JacksonCodecSupport.JSON_VIEW_HINT);
            filters = (FilterProvider)hints.get(FILTER_PROVIDER_HINT);
        }
        ObjectWriter objectWriter = writer = jsonView != null ? mapper.writerWithView(jsonView) : mapper.writer();
        if (filters != null) {
            writer = writer.with(filters);
        }
        if (javaType.isContainerType()) {
            writer = writer.forType(javaType);
        }
        return this.customizeWriter(writer, mimeType, valueType, hints);
    }

    protected ObjectWriter customizeWriter(ObjectWriter writer, @Nullable MimeType mimeType, ResolvableType elementType, @Nullable Map<String, Object> hints) {
        return writer;
    }

    protected byte @Nullable [] getStreamingMediaTypeSeparator(@Nullable MimeType mimeType) {
        for (MediaType streamingMediaType : this.streamingMediaTypes) {
            if (!streamingMediaType.isCompatibleWith(mimeType)) continue;
            return NEWLINE_SEPARATOR;
        }
        return null;
    }

    protected JsonEncoding getJsonEncoding(@Nullable MimeType mimeType) {
        Charset charset;
        JsonEncoding result;
        if (mimeType != null && mimeType.getCharset() != null && (result = ENCODINGS.get((charset = mimeType.getCharset()).name())) != null) {
            return result;
        }
        return JsonEncoding.UTF8;
    }

    @Override
    public List<MimeType> getEncodableMimeTypes() {
        return this.getMimeTypes();
    }

    @Override
    public List<MimeType> getEncodableMimeTypes(ResolvableType elementType) {
        return this.getMimeTypes(elementType);
    }

    @Override
    public List<MediaType> getStreamingMediaTypes() {
        return Collections.unmodifiableList(this.streamingMediaTypes);
    }

    @Override
    public Map<String, Object> getEncodeHints(@Nullable ResolvableType actualType, ResolvableType elementType, @Nullable MediaType mediaType, ServerHttpRequest request, ServerHttpResponse response) {
        return actualType != null ? this.getHints(actualType) : Hints.none();
    }

    @Override
    protected <A extends Annotation> @Nullable A getAnnotation(MethodParameter parameter, Class<A> annotType) {
        return parameter.getMethodAnnotation(annotType);
    }

    static {
        for (JsonEncoding encoding : JsonEncoding.values()) {
            ENCODINGS.put(encoding.getJavaName(), encoding);
        }
        ENCODINGS.put("US-ASCII", JsonEncoding.UTF8);
    }

    private static class JsonArrayJoinHelper {
        private static final byte[] COMMA_SEPARATOR = new byte[]{44};
        private static final byte[] OPEN_BRACKET = new byte[]{91};
        private static final byte[] CLOSE_BRACKET = new byte[]{93};
        private boolean firstItemEmitted;

        private JsonArrayJoinHelper() {
        }

        public byte[] getDelimiter() {
            if (this.firstItemEmitted) {
                return COMMA_SEPARATOR;
            }
            this.firstItemEmitted = true;
            return EMPTY_BYTES;
        }

        public byte[] getPrefix() {
            return this.firstItemEmitted ? EMPTY_BYTES : OPEN_BRACKET;
        }

        public byte[] getSuffix() {
            return CLOSE_BRACKET;
        }
    }
}

