/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import java.time.Duration;
import org.jspecify.annotations.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public final class ServerSentEvent<T> {
    private final @Nullable String id;
    private final @Nullable String event;
    private final @Nullable Duration retry;
    private final @Nullable String comment;
    private final @Nullable T data;

    private ServerSentEvent(@Nullable String id, @Nullable String event, @Nullable Duration retry, @Nullable String comment, @Nullable T data) {
        this.id = id;
        this.event = event;
        this.retry = retry;
        this.comment = comment;
        this.data = data;
    }

    public @Nullable String id() {
        return this.id;
    }

    public @Nullable String event() {
        return this.event;
    }

    public @Nullable Duration retry() {
        return this.retry;
    }

    public @Nullable String comment() {
        return this.comment;
    }

    public @Nullable T data() {
        return this.data;
    }

    public String format() {
        StringBuilder sb = new StringBuilder();
        if (this.id != null) {
            this.appendAttribute("id", this.id, sb);
        }
        if (this.event != null) {
            this.appendAttribute("event", this.event, sb);
        }
        if (this.retry != null) {
            this.appendAttribute("retry", this.retry.toMillis(), sb);
        }
        if (this.comment != null) {
            sb.append(':').append(StringUtils.replace(this.comment, "\n", "\n:")).append('\n');
        }
        if (this.data != null) {
            sb.append("data:");
        }
        return sb.toString();
    }

    private void appendAttribute(String fieldName, Object fieldValue, StringBuilder sb) {
        sb.append(fieldName).append(':').append(fieldValue).append('\n');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof ServerSentEvent)) return false;
        ServerSentEvent that = (ServerSentEvent)other;
        if (!ObjectUtils.nullSafeEquals(this.id, that.id)) return false;
        if (!ObjectUtils.nullSafeEquals(this.event, that.event)) return false;
        if (!ObjectUtils.nullSafeEquals(this.retry, that.retry)) return false;
        if (!ObjectUtils.nullSafeEquals(this.comment, that.comment)) return false;
        if (!ObjectUtils.nullSafeEquals(this.data, that.data)) return false;
        return true;
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHash(this.id, this.event, this.retry, this.comment, this.data);
    }

    public String toString() {
        return "ServerSentEvent [id = '" + this.id + "', event='" + this.event + "', retry=" + String.valueOf(this.retry) + ", comment='" + this.comment + "', data=" + String.valueOf(this.data) + "]";
    }

    public static <T> Builder<T> builder() {
        return new BuilderImpl();
    }

    public static <T> Builder<T> builder(T data) {
        return new BuilderImpl<T>(data);
    }

    private static class BuilderImpl<T>
    implements Builder<T> {
        private @Nullable String id;
        private @Nullable String event;
        private @Nullable Duration retry;
        private @Nullable String comment;
        private @Nullable T data;

        public BuilderImpl() {
        }

        public BuilderImpl(T data) {
            this.data = data;
        }

        @Override
        public Builder<T> id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public Builder<T> event(String event) {
            this.event = event;
            return this;
        }

        @Override
        public Builder<T> retry(Duration retry) {
            this.retry = retry;
            return this;
        }

        @Override
        public Builder<T> comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public Builder<T> data(@Nullable T data) {
            this.data = data;
            return this;
        }

        @Override
        public ServerSentEvent<T> build() {
            return new ServerSentEvent<T>(this.id, this.event, this.retry, this.comment, this.data);
        }
    }

    public static interface Builder<T> {
        public Builder<T> id(String var1);

        public Builder<T> event(String var1);

        public Builder<T> retry(Duration var1);

        public Builder<T> comment(String var1);

        public Builder<T> data(@Nullable T var1);

        public ServerSentEvent<T> build();
    }
}

