/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.observation;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.observation.OpenTelemetryServerHttpObservationDocumentation;
import org.springframework.http.server.observation.ServerRequestObservationContext;
import org.springframework.http.server.observation.ServerRequestObservationConvention;

public class OpenTelemetryServerRequestObservationConvention
implements ServerRequestObservationConvention {
    private static final String NAME = "http.server.request.duration";
    private static final KeyValue METHOD_UNKNOWN = KeyValue.of(OpenTelemetryServerHttpObservationDocumentation.LowCardinalityKeyNames.METHOD, "_OTHER");
    private static final KeyValue SCHEME_UNKNOWN = KeyValue.of(OpenTelemetryServerHttpObservationDocumentation.LowCardinalityKeyNames.SCHEME, "UNKNOWN");
    private static final KeyValue STATUS_UNKNOWN = KeyValue.of(OpenTelemetryServerHttpObservationDocumentation.LowCardinalityKeyNames.STATUS, "UNKNOWN");
    private static final KeyValue HTTP_OUTCOME_SUCCESS = KeyValue.of(OpenTelemetryServerHttpObservationDocumentation.LowCardinalityKeyNames.OUTCOME, "SUCCESS");
    private static final KeyValue HTTP_OUTCOME_UNKNOWN = KeyValue.of(OpenTelemetryServerHttpObservationDocumentation.LowCardinalityKeyNames.OUTCOME, "UNKNOWN");
    private static final KeyValue ROUTE_UNKNOWN = KeyValue.of(OpenTelemetryServerHttpObservationDocumentation.LowCardinalityKeyNames.ROUTE, "UNKNOWN");
    private static final KeyValue ROUTE_ROOT = KeyValue.of(OpenTelemetryServerHttpObservationDocumentation.LowCardinalityKeyNames.ROUTE, "root");
    private static final KeyValue ROUTE_NOT_FOUND = KeyValue.of(OpenTelemetryServerHttpObservationDocumentation.LowCardinalityKeyNames.ROUTE, "NOT_FOUND");
    private static final KeyValue ROUTE_REDIRECTION = KeyValue.of(OpenTelemetryServerHttpObservationDocumentation.LowCardinalityKeyNames.ROUTE, "REDIRECTION");
    private static final KeyValue EXCEPTION_NONE = KeyValue.of(OpenTelemetryServerHttpObservationDocumentation.LowCardinalityKeyNames.EXCEPTION, "none");
    private static final KeyValue HTTP_URL_UNKNOWN = KeyValue.of(OpenTelemetryServerHttpObservationDocumentation.HighCardinalityKeyNames.URL_PATH, "UNKNOWN");
    private static final KeyValue ORIGINAL_METHOD_UNKNOWN = KeyValue.of(OpenTelemetryServerHttpObservationDocumentation.HighCardinalityKeyNames.METHOD_ORIGINAL, "UNKNOWN");
    private static final Set<String> HTTP_METHODS = Stream.of(HttpMethod.values()).map(HttpMethod::name).collect(Collectors.toUnmodifiableSet());

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getContextualName(ServerRequestObservationContext context) {
        if (context.getCarrier() == null) {
            return "HTTP";
        }
        String maybeMethod = this.getMethodValue(context);
        String method = maybeMethod == null ? "HTTP" : maybeMethod;
        String target = context.getPathPattern();
        if (target != null) {
            return method + " " + target;
        }
        return method;
    }

    @Override
    public KeyValues getLowCardinalityKeyValues(ServerRequestObservationContext context) {
        return KeyValues.of(this.exception(context), this.method(context), this.status(context), this.pathTemplate(context), this.outcome(context), this.scheme(context));
    }

    @Override
    public KeyValues getHighCardinalityKeyValues(ServerRequestObservationContext context) {
        return KeyValues.of(this.methodOriginal(context), this.httpUrl(context));
    }

    protected KeyValue method(ServerRequestObservationContext context) {
        String method = this.getMethodValue(context);
        if (method != null) {
            return KeyValue.of(OpenTelemetryServerHttpObservationDocumentation.LowCardinalityKeyNames.METHOD, method);
        }
        return METHOD_UNKNOWN;
    }

    protected @Nullable String getMethodValue(ServerRequestObservationContext context) {
        String httpMethod;
        if (context.getCarrier() != null && HTTP_METHODS.contains(httpMethod = ((HttpServletRequest)context.getCarrier()).getMethod())) {
            return httpMethod;
        }
        return null;
    }

    protected KeyValue scheme(ServerRequestObservationContext context) {
        if (context.getCarrier() != null) {
            return KeyValue.of(OpenTelemetryServerHttpObservationDocumentation.LowCardinalityKeyNames.SCHEME, ((HttpServletRequest)context.getCarrier()).getScheme());
        }
        return SCHEME_UNKNOWN;
    }

    protected KeyValue status(ServerRequestObservationContext context) {
        return context.getResponse() != null ? KeyValue.of(OpenTelemetryServerHttpObservationDocumentation.LowCardinalityKeyNames.STATUS, Integer.toString(((HttpServletResponse)context.getResponse()).getStatus())) : STATUS_UNKNOWN;
    }

    protected KeyValue pathTemplate(ServerRequestObservationContext context) {
        if (context.getCarrier() != null) {
            HttpStatus status;
            String pattern = context.getPathPattern();
            if (pattern != null) {
                if (pattern.isEmpty()) {
                    return ROUTE_ROOT;
                }
                return KeyValue.of(OpenTelemetryServerHttpObservationDocumentation.LowCardinalityKeyNames.ROUTE, pattern);
            }
            if (context.getResponse() != null && (status = HttpStatus.resolve(((HttpServletResponse)context.getResponse()).getStatus())) != null) {
                if (status.is3xxRedirection()) {
                    return ROUTE_REDIRECTION;
                }
                if (status == HttpStatus.NOT_FOUND) {
                    return ROUTE_NOT_FOUND;
                }
            }
        }
        return ROUTE_UNKNOWN;
    }

    protected KeyValue exception(ServerRequestObservationContext context) {
        Throwable error = context.getError();
        if (error != null) {
            return KeyValue.of(OpenTelemetryServerHttpObservationDocumentation.LowCardinalityKeyNames.EXCEPTION, error.getClass().getName());
        }
        return EXCEPTION_NONE;
    }

    protected KeyValue outcome(ServerRequestObservationContext context) {
        try {
            if (context.getResponse() != null) {
                HttpStatusCode statusCode = HttpStatusCode.valueOf(((HttpServletResponse)context.getResponse()).getStatus());
                return HttpOutcome.forStatus(statusCode);
            }
        }
        catch (IllegalArgumentException ex) {
            return HTTP_OUTCOME_UNKNOWN;
        }
        return HTTP_OUTCOME_UNKNOWN;
    }

    protected KeyValue httpUrl(ServerRequestObservationContext context) {
        if (context.getCarrier() != null) {
            return KeyValue.of(OpenTelemetryServerHttpObservationDocumentation.HighCardinalityKeyNames.URL_PATH, ((HttpServletRequest)context.getCarrier()).getRequestURI());
        }
        return HTTP_URL_UNKNOWN;
    }

    protected KeyValue methodOriginal(ServerRequestObservationContext context) {
        if (context.getCarrier() != null) {
            return KeyValue.of(OpenTelemetryServerHttpObservationDocumentation.HighCardinalityKeyNames.METHOD_ORIGINAL, ((HttpServletRequest)context.getCarrier()).getMethod());
        }
        return ORIGINAL_METHOD_UNKNOWN;
    }

    static class HttpOutcome {
        HttpOutcome() {
        }

        static KeyValue forStatus(HttpStatusCode statusCode) {
            if (statusCode.is2xxSuccessful()) {
                return HTTP_OUTCOME_SUCCESS;
            }
            if (statusCode instanceof HttpStatus) {
                HttpStatus status = (HttpStatus)statusCode;
                return KeyValue.of(OpenTelemetryServerHttpObservationDocumentation.LowCardinalityKeyNames.OUTCOME, status.series().name());
            }
            return HTTP_OUTCOME_UNKNOWN;
        }
    }
}

