/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;

final class MultiToSingleValueMapAdapter<K, V>
implements Map<K, V>,
Serializable {
    private final MultiValueMap<K, V> targetMap;
    private transient @Nullable Collection<V> values;
    private transient @Nullable Set<Map.Entry<K, V>> entries;

    public MultiToSingleValueMapAdapter(MultiValueMap<K, V> targetMap) {
        Assert.notNull(targetMap, "'targetMap' must not be null");
        this.targetMap = targetMap;
    }

    @Override
    public int size() {
        return this.targetMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.targetMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.targetMap.containsKey(key);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        Iterator<Map.Entry<K, V>> i2 = this.entrySet().iterator();
        if (value == null) {
            while (i2.hasNext()) {
                Map.Entry<K, V> e = i2.next();
                if (e.getValue() != null) continue;
                return true;
            }
        } else {
            while (i2.hasNext()) {
                Map.Entry<K, V> e = i2.next();
                if (!value.equals(e.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public @Nullable V get(Object key) {
        return this.adaptValue((List)this.targetMap.get(key));
    }

    @Override
    public @Nullable V put(K key, @Nullable V value) {
        return this.adaptValue(this.targetMap.put(key, this.adaptValue(value)));
    }

    @Override
    public @Nullable V remove(Object key) {
        return this.adaptValue((List)this.targetMap.remove(key));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.targetMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.targetMap.keySet();
    }

    @Override
    public Collection<V> values() {
        AbstractCollection values = this.values;
        if (values == null) {
            final Collection targetValues = this.targetMap.values();
            this.values = values = new AbstractCollection<V>(this){
                final /* synthetic */ MultiToSingleValueMapAdapter this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Iterator<V> iterator() {
                    final Iterator targetIterator = targetValues.iterator();
                    return new Iterator<V>(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public boolean hasNext() {
                            return targetIterator.hasNext();
                        }

                        @Override
                        public V next() {
                            return ((List)targetIterator.next()).get(0);
                        }
                    };
                }

                @Override
                public int size() {
                    return targetValues.size();
                }
            };
        }
        return values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        AbstractSet entries = this.entries;
        if (entries == null) {
            final Set targetEntries = this.targetMap.entrySet();
            this.entries = entries = new AbstractSet<Map.Entry<K, V>>(this){
                final /* synthetic */ MultiToSingleValueMapAdapter this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    final Iterator targetIterator = targetEntries.iterator();
                    return new Iterator<Map.Entry<K, V>>(this){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public boolean hasNext() {
                            return targetIterator.hasNext();
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            Map.Entry entry = (Map.Entry)targetIterator.next();
                            return new AbstractMap.SimpleImmutableEntry(entry.getKey(), ((List)entry.getValue()).get(0));
                        }
                    };
                }

                @Override
                public int size() {
                    return targetEntries.size();
                }
            };
        }
        return entries;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.targetMap.forEach((k, vs) -> action.accept((Object)k, (Object)vs.get(0)));
    }

    private @Nullable V adaptValue(@Nullable List<V> values) {
        if (!CollectionUtils.isEmpty(values)) {
            return values.get(0);
        }
        return null;
    }

    private @Nullable List<V> adaptValue(@Nullable V value) {
        if (value != null) {
            return Collections.singletonList(value);
        }
        return null;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Map) {
            Map otherMap = (Map)other;
            if (this.size() == otherMap.size()) {
                try {
                    for (Map.Entry<K, V> e : this.entrySet()) {
                        K key = e.getKey();
                        V value = e.getValue();
                        if (!(value == null ? otherMap.get(key) != null || !otherMap.containsKey(key) : !value.equals(otherMap.get(key)))) continue;
                        return false;
                    }
                    return true;
                }
                catch (ClassCastException | NullPointerException runtimeException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.targetMap.hashCode();
    }

    public String toString() {
        return this.targetMap.toString();
    }
}

