/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;

final class SingleToMultiValueMapAdapter<K, V>
implements MultiValueMap<K, V>,
Serializable {
    private final Map<K, V> targetMap;
    private transient @Nullable Collection<List<V>> values;
    private transient @Nullable Set<Map.Entry<K, List<V>>> entries;

    public SingleToMultiValueMapAdapter(Map<K, V> targetMap) {
        Assert.notNull(targetMap, "'targetMap' must not be null");
        this.targetMap = targetMap;
    }

    @Override
    public @Nullable V getFirst(K key) {
        return this.targetMap.get(key);
    }

    @Override
    public void add(K key, @Nullable V value) {
        if (this.targetMap.containsKey(key)) {
            throw new UnsupportedOperationException("Duplicate key: " + String.valueOf(key));
        }
        this.targetMap.put(key, value);
    }

    @Override
    public void addAll(K key, List<? extends V> values) {
        if (this.targetMap.containsKey(key)) {
            throw new UnsupportedOperationException("Duplicate key: " + String.valueOf(key));
        }
        this.put(key, values);
    }

    @Override
    public void addAll(MultiValueMap<K, V> values) {
        values.forEach(this::addAll);
    }

    @Override
    public void set(K key, @Nullable V value) {
        this.targetMap.put(key, value);
    }

    @Override
    public void setAll(Map<K, V> values) {
        this.targetMap.putAll(values);
    }

    @Override
    public Map<K, V> toSingleValueMap() {
        return Collections.unmodifiableMap(this.targetMap);
    }

    @Override
    public int size() {
        return this.targetMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.targetMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.targetMap.containsKey(key);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        Iterator<Map.Entry<K, List<V>>> i2 = this.entrySet().iterator();
        if (value == null) {
            while (i2.hasNext()) {
                Map.Entry<K, List<V>> e = i2.next();
                if (e.getValue() != null && !e.getValue().isEmpty()) continue;
                return true;
            }
        } else {
            while (i2.hasNext()) {
                Map.Entry<K, List<V>> e = i2.next();
                if (!value.equals(e.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public @Nullable List<V> get(Object key) {
        V value = this.targetMap.get(key);
        return value != null ? Collections.singletonList(value) : null;
    }

    @Override
    public @Nullable List<V> put(K key, List<V> values) {
        if (values.isEmpty()) {
            Object result = this.targetMap.put(key, null);
            return result != null ? Collections.singletonList(result) : null;
        }
        if (values.size() == 1) {
            V result = this.targetMap.put(key, values.get(0));
            return result != null ? Collections.singletonList(result) : null;
        }
        throw new UnsupportedOperationException("Duplicate key: " + String.valueOf(key));
    }

    @Override
    public @Nullable List<V> remove(Object key) {
        V result = this.targetMap.remove(key);
        return result != null ? Collections.singletonList(result) : null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends List<V>> map) {
        for (Map.Entry<K, List<V>> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.targetMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.targetMap.keySet();
    }

    @Override
    public Collection<List<V>> values() {
        AbstractCollection values = this.values;
        if (values == null) {
            final Collection<V> targetValues = this.targetMap.values();
            this.values = values = new AbstractCollection<List<V>>(this){
                final /* synthetic */ SingleToMultiValueMapAdapter this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Iterator<List<V>> iterator() {
                    final Iterator targetIterator = targetValues.iterator();
                    return new Iterator<List<V>>(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public boolean hasNext() {
                            return targetIterator.hasNext();
                        }

                        @Override
                        public List<V> next() {
                            return Collections.singletonList(targetIterator.next());
                        }
                    };
                }

                @Override
                public int size() {
                    return targetValues.size();
                }
            };
        }
        return values;
    }

    @Override
    public Set<Map.Entry<K, List<V>>> entrySet() {
        AbstractSet entries = this.entries;
        if (entries == null) {
            final Set<Map.Entry<K, V>> targetEntries = this.targetMap.entrySet();
            this.entries = entries = new AbstractSet<Map.Entry<K, List<V>>>(this){
                final /* synthetic */ SingleToMultiValueMapAdapter this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Iterator<Map.Entry<K, List<V>>> iterator() {
                    final Iterator targetIterator = targetEntries.iterator();
                    return new Iterator<Map.Entry<K, List<V>>>(this){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public boolean hasNext() {
                            return targetIterator.hasNext();
                        }

                        @Override
                        public Map.Entry<K, List<V>> next() {
                            Map.Entry entry = (Map.Entry)targetIterator.next();
                            return new AbstractMap.SimpleImmutableEntry(entry.getKey(), Collections.singletonList(entry.getValue()));
                        }
                    };
                }

                @Override
                public int size() {
                    return targetEntries.size();
                }
            };
        }
        return entries;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super List<V>> action) {
        this.targetMap.forEach((? super K k, ? super V v) -> action.accept((Object)k, (Object)Collections.singletonList(v)));
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Map) {
            Map otherMap = (Map)other;
            if (this.size() == otherMap.size()) {
                try {
                    for (Map.Entry<K, List<V>> e : this.entrySet()) {
                        K key = e.getKey();
                        List<V> values = e.getValue();
                        if (!(values == null ? otherMap.get(key) != null || !otherMap.containsKey(key) : !values.equals(otherMap.get(key)))) continue;
                        return false;
                    }
                    return true;
                }
                catch (ClassCastException | NullPointerException runtimeException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.targetMap.hashCode();
    }

    public String toString() {
        return this.targetMap.toString();
    }
}

