/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind.annotation;

import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;

public enum RequestMethod {
    GET,
    HEAD,
    POST,
    PUT,
    PATCH,
    DELETE,
    OPTIONS,
    TRACE;


    public static @Nullable RequestMethod resolve(String method) {
        Assert.notNull((Object)method, "Method must not be null");
        return switch (method) {
            case "GET" -> GET;
            case "HEAD" -> HEAD;
            case "POST" -> POST;
            case "PUT" -> PUT;
            case "PATCH" -> PATCH;
            case "DELETE" -> DELETE;
            case "OPTIONS" -> OPTIONS;
            case "TRACE" -> TRACE;
            default -> null;
        };
    }

    public static @Nullable RequestMethod resolve(HttpMethod httpMethod) {
        Assert.notNull((Object)httpMethod, "HttpMethod must not be null");
        return RequestMethod.resolve(httpMethod.name());
    }

    public HttpMethod asHttpMethod() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> HttpMethod.GET;
            case 1 -> HttpMethod.HEAD;
            case 2 -> HttpMethod.POST;
            case 3 -> HttpMethod.PUT;
            case 4 -> HttpMethod.PATCH;
            case 5 -> HttpMethod.DELETE;
            case 6 -> HttpMethod.OPTIONS;
            case 7 -> HttpMethod.TRACE;
        };
    }
}

