/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.core.log.LogFormatUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.ClientHttpResponseDecorator;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpMessageConverterExtractor;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.client.RestClientUtils;
import org.springframework.web.client.UnknownHttpStatusCodeException;

final class StatusHandler {
    private final ResponsePredicate predicate;
    private final RestClient.ResponseSpec.ErrorHandler handler;

    private StatusHandler(ResponsePredicate predicate, RestClient.ResponseSpec.ErrorHandler handler) {
        this.predicate = predicate;
        this.handler = handler;
    }

    public boolean test(ClientHttpResponse response) throws IOException {
        return this.predicate.test(response);
    }

    public void handle(HttpRequest request, ClientHttpResponse response) throws IOException {
        this.handler.handle(request, response);
    }

    public static StatusHandler of(Predicate<HttpStatusCode> predicate, RestClient.ResponseSpec.ErrorHandler errorHandler) {
        Assert.notNull(predicate, "Predicate must not be null");
        Assert.notNull((Object)errorHandler, "ErrorHandler must not be null");
        return new StatusHandler(response -> predicate.test(response.getStatusCode()), errorHandler);
    }

    public static StatusHandler fromErrorHandler(ResponseErrorHandler errorHandler) {
        Assert.notNull((Object)errorHandler, "ResponseErrorHandler must not be null");
        return new StatusHandler(errorHandler::hasError, (request, response) -> errorHandler.handleError(request.getURI(), request.getMethod(), response));
    }

    public static StatusHandler createDefaultStatusHandler(List<HttpMessageConverter<?>> converters) {
        return new StatusHandler(response -> response.getStatusCode().isError(), (request, response) -> {
            throw StatusHandler.createException(response, converters);
        });
    }

    public static RestClientResponseException createException(ClientHttpResponse response, List<HttpMessageConverter<?>> converters) throws IOException {
        HttpStatusCode statusCode = response.getStatusCode();
        String statusText = response.getStatusText();
        HttpHeaders headers = response.getHeaders();
        byte[] body2 = RestClientUtils.getBody(response);
        Charset charset = RestClientUtils.getCharset(response);
        String message = StatusHandler.getErrorMessage(statusCode.value(), statusText, body2, charset);
        RestClientResponseException ex = statusCode.is4xxClientError() ? HttpClientErrorException.create(message, statusCode, statusText, headers, body2, charset) : (statusCode.is5xxServerError() ? HttpServerErrorException.create(message, statusCode, statusText, headers, body2, charset) : new UnknownHttpStatusCodeException(message, statusCode.value(), statusText, headers, body2, charset));
        if (!CollectionUtils.isEmpty(converters)) {
            ex.setBodyConvertFunction(StatusHandler.initBodyConvertFunction(response, body2, converters));
        }
        return ex;
    }

    private static String getErrorMessage(int rawStatusCode, String statusText, byte @Nullable [] responseBody, @Nullable Charset charset) {
        String preface = rawStatusCode + " " + statusText + ": ";
        if (ObjectUtils.isEmpty((Object)responseBody)) {
            return preface + "[no body]";
        }
        charset = charset != null ? charset : StandardCharsets.UTF_8;
        String bodyText = new String(responseBody, charset);
        bodyText = LogFormatUtils.formatValue(bodyText, -1, true);
        return preface + bodyText;
    }

    private static Function<ResolvableType, ? extends @Nullable Object> initBodyConvertFunction(ClientHttpResponse response, final byte[] body2, List<HttpMessageConverter<?>> messageConverters) {
        return resolvableType -> {
            try {
                HttpMessageConverterExtractor extractor = new HttpMessageConverterExtractor(resolvableType.getType(), messageConverters);
                return extractor.extractData(new ClientHttpResponseDecorator(response){

                    @Override
                    public InputStream getBody() {
                        return new ByteArrayInputStream(body2);
                    }
                });
            }
            catch (IOException ex) {
                throw new RestClientException("Error while extracting response for type [" + String.valueOf(resolvableType) + "]", ex);
            }
        };
    }

    @FunctionalInterface
    private static interface ResponsePredicate {
        public boolean test(ClientHttpResponse var1) throws IOException;
    }
}

