/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.service.registry;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.generate.MethodReference;
import org.springframework.aot.generate.ValueCodeGenerator;
import org.springframework.javapoet.CodeBlock;
import org.springframework.web.service.registry.GroupsMetadata;

final class GroupsMetadataValueDelegate
implements ValueCodeGenerator.Delegate {
    GroupsMetadataValueDelegate() {
    }

    @Override
    public @Nullable CodeBlock generateCode(ValueCodeGenerator valueCodeGenerator, Object value) {
        if (value instanceof GroupsMetadata.Registration) {
            GroupsMetadata.Registration registration = (GroupsMetadata.Registration)value;
            return this.generateRegistrationCode(valueCodeGenerator, registration);
        }
        if (value instanceof GroupsMetadata) {
            GroupsMetadata groupsMetadata = (GroupsMetadata)value;
            return this.generateGroupsMetadataCode(valueCodeGenerator, groupsMetadata);
        }
        return null;
    }

    public CodeBlock generateRegistrationCode(ValueCodeGenerator valueCodeGenerator, GroupsMetadata.Registration value) {
        CodeBlock.Builder code = CodeBlock.builder();
        code.add("new $T($S, $L, $L)", GroupsMetadata.Registration.class, value.name(), valueCodeGenerator.generateCode((Object)value.clientType()), !value.httpServiceTypeNames().isEmpty() ? valueCodeGenerator.generateCode(value.httpServiceTypeNames()) : CodeBlock.of("new $T()", LinkedHashSet.class));
        return code.build();
    }

    private CodeBlock generateGroupsMetadataCode(ValueCodeGenerator valueCodeGenerator, GroupsMetadata groupsMetadata) {
        Collection registrations = groupsMetadata.registrations().collect(Collectors.toCollection(ArrayList::new));
        if (valueCodeGenerator.getGeneratedMethods() != null) {
            return valueCodeGenerator.getGeneratedMethods().add("getGroupsMetadata", method -> method.addJavadoc("Create the {@link $T}.", GroupsMetadata.class).addModifiers(Modifier.PRIVATE, Modifier.STATIC).returns((Type)((Object)GroupsMetadata.class)).addCode(this.generateGroupsMetadataMethod(valueCodeGenerator, registrations))).toMethodReference().toInvokeCodeBlock(MethodReference.ArgumentCodeGenerator.none());
        }
        return CodeBlock.of("new $T($L)", GroupsMetadata.class, valueCodeGenerator.generateCode(registrations));
    }

    private CodeBlock generateGroupsMetadataMethod(ValueCodeGenerator valueCodeGenerator, Collection<GroupsMetadata.Registration> registrations) {
        CodeBlock.Builder code = CodeBlock.builder();
        String registrationsVariable = "registrations";
        code.addStatement("$T<$T> $L = new $T<>()", List.class, GroupsMetadata.Registration.class, registrationsVariable, ArrayList.class);
        registrations.forEach(registration -> code.addStatement("$L.add($L)", registrationsVariable, valueCodeGenerator.generateCode(registration)));
        code.addStatement("return new $T($L)", GroupsMetadata.class, registrationsVariable);
        return code.build();
    }
}

