/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.core.NestedExceptionUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class DisconnectedClientHelper {
    private static final Set<String> EXCEPTION_PHRASES = Set.of("broken pipe", "connection reset by peer");
    private static final Set<String> EXCEPTION_TYPE_NAMES = Set.of("AbortedException", "ClientAbortException", "EOFException", "EofException", "AsyncRequestNotUsableException");
    private static final Set<Class<?>> EXCLUDED_EXCEPTION_TYPES = new LinkedHashSet(4);
    private final Log logger;

    public DisconnectedClientHelper(String logCategory) {
        Assert.notNull((Object)logCategory, "'logCategory' is required");
        this.logger = LogFactory.getLog(logCategory);
    }

    public boolean checkAndLogClientDisconnectedException(Throwable ex) {
        if (DisconnectedClientHelper.isClientDisconnectedException(ex)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Looks like the client has gone away", ex);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("Looks like the client has gone away: " + String.valueOf(ex) + " (For a full stack trace, set the log category '" + String.valueOf(this.logger) + "' to TRACE level.)");
            }
            return true;
        }
        return false;
    }

    public static boolean isClientDisconnectedException(@Nullable Throwable ex) {
        if (ex == null) {
            return false;
        }
        Throwable lastEx = null;
        for (Throwable currentEx = ex; currentEx != null && currentEx != lastEx; currentEx = currentEx.getCause()) {
            for (Class<?> exceptionType : EXCLUDED_EXCEPTION_TYPES) {
                if (!exceptionType.isInstance(currentEx)) continue;
                return false;
            }
            if (EXCEPTION_TYPE_NAMES.contains(currentEx.getClass().getSimpleName())) {
                return true;
            }
            lastEx = currentEx;
        }
        String message = NestedExceptionUtils.getMostSpecificCause(ex).getMessage();
        if (message != null) {
            String text = message.toLowerCase(Locale.ROOT);
            for (String phrase : EXCEPTION_PHRASES) {
                if (!text.contains(phrase)) continue;
                return true;
            }
        }
        return false;
    }

    private static void addExcludedExceptionType(String type) {
        try {
            ClassLoader classLoader = DisconnectedClientHelper.class.getClassLoader();
            EXCLUDED_EXCEPTION_TYPES.add(ClassUtils.forName(type, classLoader));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    static {
        DisconnectedClientHelper.addExcludedExceptionType("org.springframework.web.client.RestClientException");
        DisconnectedClientHelper.addExcludedExceptionType("org.springframework.web.reactive.function.client.WebClientException");
        DisconnectedClientHelper.addExcludedExceptionType("org.springframework.dao.DataAccessException");
        DisconnectedClientHelper.addExcludedExceptionType("org.springframework.messaging.MessagingException");
    }
}

